/************************************************************************
 * utils.c -- various utilities for rpncalc				*
 *									*
 * A little RPN (Reverse Polish Notation) calculator,                   *
 * rudimentary emulating a HP 28S. 					*
 * 								        *
 * rpncalc is (c) David Frey, 1993, 1994, 1995				*
 *								        * 
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *									* 
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *									* 
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *									* 
 ************************************************************************/

/* $Id: utils.c,v 1.2 1996/09/13 20:21:29 david Rel $
 * $Log: utils.c,v $
 * Revision 1.2  1996/09/13 20:21:29  david
 * lclint additions
 *
 * Revision 1.1  1996/07/13 20:58:36  david
 * Added dupstr()
 * Moved getline() from rpncalc.c into utils.c
 *
 * Revision 1.0  1995/12/31 18:19:34  david
 * Initial revision
 *
 * Revision 1.0  1995/11/25 20:02:25  david
 * Initial revision
 * */

#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_READLINE
#include <readline/readline.h>
#include <readline/history.h>
#endif

#define LINEFRAGMENT 32

/*@out@*/ void *xmalloc(size_t size)	/* safe malloc */
{
  void *ptr;

  ptr=malloc(size);
  if (ptr == NULL) 
  {
    perror("Out of memory!"); 
    exit(1); 
  }

  return ptr;
}

/*@out@*/ void *xrealloc(void *ptr, size_t size)	/* save realloc */
{
  ptr=realloc(ptr, size);
  if (ptr == NULL) 
  {
    perror("Out of memory!"); 
    exit(1); 
  }

  return ptr;
}

char *dupstr(char *s)
{
  char *r;

  r = xmalloc (strlen (s) + 1);
  strcpy (r, s);
  return (r);
}

/*@null@*/ char *getline(void)
/* Read a line of text without imposing an length limit.
   If we readline support is compiled in, use the readline function. */
{
  unsigned char *line=NULL;
#ifndef HAVE_READLINE
  int c;
  int i;
#endif

#ifdef HAVE_READLINE
  line=(unsigned char*)readline(""); 
#else
  i=0; line=(unsigned char *)xmalloc((size_t)(LINEFRAGMENT+1));
  while (((c = getc(stdin)) != EOF) && (c != '\n') && (c != '\0'))
  {
   if ((i > LINEFRAGMENT) &&  (i % LINEFRAGMENT) == 0) 
     line=(unsigned char *)xrealloc(line,(size_t)(LINEFRAGMENT+1));
   line[i]=(unsigned char)c; i++;
  }
  if ((c != EOF) && (c != '\0')) line[i]='\0';
  else
  {
    free(line); line=NULL;   /* this is readline compatible; 
				return NULL when the input line is empty */
  }
#endif

  return line;
}
