/**********************************************************************
** $Id: qpsprn.h,v 2.0 1996/09/24 10:15:59 agulbra Exp $
**
**		      ***   INTERNAL HEADER FILE   ***
**
**		This file is NOT a part of the Qt interface!
**
** Definition of internal QPSPrinter class.
** QPSPrinter implements PostScript (tm) output via QPrinter.
**
** Created : 940927
**
** Copyright (C) 1992-1996 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.0
** see the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the commercial version of Qt only by this comment.)
**
*****************************************************************************/

#ifndef QPSPRN_H
#define QPSPRN_H

#include "qprinter.h"
#include "qtstream.h"


class QPSPrinter : public QPaintDevice
{
private:
    QPSPrinter( QPrinter * );
   ~QPSPrinter();

    bool	cmd ( int, QPainter *, QPDevCmdParam * );

    QPrinter   *printer;
    QIODevice  *device;
    QTextStream stream;
    int		pageCount;
    bool	dirtyMatrix;
    QString	fontsUsed;
    friend class QPrinter;

private:	// Disabled copy constructor and operator=
    QPSPrinter( const QPSPrinter & ):QPaintDevice(0) {}
    QPSPrinter &operator=( const QPSPrinter & ) { return *this; }
};


// Additional commands for QPSPrinter

#define PDC_PRT_NEWPAGE 100
#define PDC_PRT_ABORT	101


#endif // QPSPRN_H
