/*
 * RadioMenuItem - radio menu item
 *
 * created: apesen, mpichler, 19961001
 *
 * changed: apesen, 19961114
 *
 * $Id: RadioMenuItem.java,v 1.1 1997/01/15 13:42:55 mpichler Exp $
 */


package iicm.widgets;

import java.awt.*;

// 02.10.96 apesen
// RadioMenuItem 
// RadioMenuCheckbox

public class RadioMenuItem extends CheckboxMenuItem
{
  RadioMenuCheckbox box;

  public RadioMenuItem (String label, CheckboxGroup cbg)
  {
    super(label);
    box = new RadioMenuCheckbox(label, cbg, this);
  }

// public synchronized void addNotify ()
// {
// System.out.println ("RadioMenuItem.addNotify");
// super.addNotify ();
// }

  public void setState (boolean flag)
  {
    if (flag)  // only may turn on an item
    {
      // System.out.println ("turning menu item on");
      super.setState (flag);
      box.setState (flag);
    }
    else  // no, don't turn me off
      super.setState (true);
  }

  public void doSetState (boolean flag)
  { // set state flag unconditionally
    super.setState (flag);
    // System.out.println ("turning old menu item off");
  }
} // RadioMenuItem


class RadioMenuCheckbox extends Checkbox
{
  RadioMenuItem mitem;

  public RadioMenuCheckbox (String label, CheckboxGroup cbg, RadioMenuItem mi)
  {
    super(label, cbg, false);
    mitem = mi;
  }

  public void setState (boolean flag)
  {
    super.setState (flag);
    if (!flag)
      mitem.doSetState (flag);
  }
} // RadioMenuCheckbox
