/*
 * SceneFrame - scene frame
 *
 * created: mpichler, 19960923
 *
 * changed: kwagen, 19970807
 * changed: mpichler, 19970918
 *
 * $Id: SceneFrame.java,v 1.26 1997/09/19 15:46:58 mpichler Exp $
 */


package iicm.vrml.vrwave;

import iicm.ge3d.GE3D;
import iicm.widgets.*;

import java.awt.*;


/**
 * SceneFrame - VRwave frame (window)
 * Copyright (c) 1997 IICM
 */

public class SceneFrame extends Frame
{
  private Scene scene_;
  private MenuItem[] menuitem_ = new MenuItem [MenuDef.M_NUMMENUITEMS];

  /**
   * SceneFrame constructor
   * @arg title - window title (needed for creating the canvas)
   * @arg scene - the scene to be managed
   * @arg canvas - flag whether to include canvas or show toolbox only
   */

  public SceneFrame (String title, Scene s, boolean canvas)
  {
    super (title);

    setLayout (new BorderLayout ());
    scene_ = s;
    s.setFrame (this);  // for dialogs

    System.err.println ("initializing Frame ...");  // this may take a few seconds

    createMenus ();
    s.setMenus (menuitem_);  // to update toggle/radio menu items

//     Panel buttonrow = new Panel ();
//     buttonrow.setLayout (new FlowLayout (FlowLayout.LEFT, 5, 1));  // hgap, vgap
//     // Buttons request the focus
//     buttonrow.add (new FramedArea (new Label ("flip")));  // translator!!!
//     buttonrow.add (new FramedArea (new Label ("walk")));  // translator!!!
//     buttonrow.setFont (Fontify.fntButton);
//     add ("North", buttonrow);

    add ("North", new Iconbar (s));

    if (canvas)
      add ("Center", new SceneCanvas (title, s));

//     Panel statusline = new Panel ();
//     statusline.setLayout (new BorderLayout ());
//     Label label = new Label ("VRwave");
//     label.setFont (Fontify.fntLabel1);
//     statusline.add ("West", label);
//     Label label2 = new Label ("IICM");
//     label2.setFont (Fontify.fntLabel1);
//     statusline.add ("East", label2);

    StatusBar statusline = new StatusBar ();
    PropPanel readybar = new PropPanel (statusline, 35);
    PropPanel workingbar = new PropPanel (statusline, 35);

    readybar.addField (new StatusTextField ("VRwave", readybar, 70));
    readybar.addField (new StatusTextField ("IICM", readybar, 30));

    Progress progress = new Progress (workingbar, 20);
    workingbar.addField (new StatusTextField ("", workingbar, 80));
    workingbar.addField (progress);
    workingbar.addField (new StatusButton ("Stop", workingbar, PropField.USENATURALSIZE));

    statusline.addBar ("READY", readybar);  // first
    statusline.addBar ("WORKING", workingbar);  // last

    s.setProgressbar (statusline, progress);

    add ("South", statusline);  // status line (will be replaced by progress indicator)

    if (canvas)
      resize (640, 520);  // initial frame (window) size (incl. window decoration)
    else  // (190, 135);  // two menu lines
      resize (290, 145);  // initial menu toolbox size (add about (10, 30) for window decoration)
    // or: pack ();  // combine preferredSize of all components

    show ();  // display (map) frame

    initMenus ();  // some platforms require menupeer objects to change states

  } // constructor


  /**
   * create the menubar.
   * only a frame (window) may have a menubar, not an applet
   */

  void createMenus ()
  {
    int language = Translator.language_;  // sync problems with JDK 1.0.2 when put into call below
    String[][] strings = Translator.strings;
    MenuBar mb = MenuBuilder.buildMenu (MenuDef.MenuIDs, strings, language, menuitem_, true);

    setMenuBar (mb);

  } // createMenus

  /**
   * initialize menu item states (radio groups, disable)
   */

  private void initMenus ()
  {
    int[] disable = {
      // File
      MenuDef.M_SaveAs, MenuDef.M_Edit, MenuDef.M_Print, MenuDef.M_ViewParser,
      // Navigate
      MenuDef.M_PrevViewpoint, MenuDef.M_NextViewpoint, MenuDef.M_Options,
    };

    // disabled menu items
    int i, mode;
    for (i = 0;  i < disable.length;  i++)
      menuitem_ [disable [i]].disable ();

    // initial state of radio menu groups
    // (the states will have been read from config files)
    // be careful that the menus contain all posibble options (cast exception)

    // navigation mode
    if (scene_.movemode_ == Scene.HEADSUP)
      i = MenuDef.M_HeadsUp;
    else if (scene_.movemode_ == Scene.FLYTO)
      i = MenuDef.M_FlyTo;
    else  // (assert: continuous labels)
      i = MenuDef.M_Flip + (scene_.movemode_ - Scene.FLIP);
    ((RadioMenuItem) menuitem_[i]).setState (true);

    // behavior
    ((CheckboxMenuItem) menuitem_[MenuDef.M_Behaviour]).setState (scene_.getBehavior ());

    // interaction
    ((CheckboxMenuItem) menuitem_[MenuDef.M_Interaction]).setState (scene_.getInteraction ());

    // drawing mode (assert: continuous labels)
    i = MenuDef.M_Wireframe + (scene_.normalDrawingMode () - GE3D.ge3d_wireframe);
    ((RadioMenuItem) menuitem_[i]).setState (true);

    // interactive drawing mode
    mode = scene_.interDrawingMode ();
    if (mode < 0)
      i = MenuDef.M_ITheSame;
    else  // (assert: continuous labels)
      i = MenuDef.M_IWireframe + (mode - GE3D.ge3d_wireframe);
    ((RadioMenuItem) menuitem_[i]).setState (true);

    // two sided polygons (i.e. !backfaceculling)
    mode = scene_.backfaceCulling ();
    i = (mode == Scene.TRISTATE_AUTO) ? MenuDef.M_TSPauto
    : (mode == Scene.TRISTATE_ON) ? MenuDef.M_TSPoff : MenuDef.M_TSPon;
    ((RadioMenuItem) menuitem_[i]).setState (true);    

    // texture mipmapping
    i = MenuDef.M_AATexturesOff + scene_.getTextureMipmapping ();
    ((RadioMenuItem) menuitem_[i]).setState (true);    

    // lighting
    mode = scene_.getLighting ();
    i = (mode == Scene.TRISTATE_AUTO) ? MenuDef.M_LCauto
    : (mode == Scene.TRISTATE_ON) ? MenuDef.M_LCon : MenuDef.M_LCoff;
    ((RadioMenuItem) menuitem_[i]).setState (true);    

    // texture lighting
    i = MenuDef.M_LConText;
    ((CheckboxMenuItem) menuitem_[i]).setState (scene_.getTexLighting ());

    // materials on/off
    i = MenuDef.M_LCnoMat;
    ((CheckboxMenuItem) menuitem_[i]).setState (!scene_.materials ());

    // transparency method
    i = MenuDef.M_TPoff + scene_.getTranspMethod ();
    ((RadioMenuItem) menuitem_[i]).setState (true);

    // texture transparency
    i = MenuDef.M_TPonText;
    ((CheckboxMenuItem) menuitem_[i]).setState (scene_.getTextureTransparency ());

  } // initMenus

  /**
   * menu actions
   */

  public boolean action (Event e, Object arg)
  {
    if (e.target instanceof MenuItem)
    { 
      MenuItem item = (MenuItem) e.target;
      MenuItem[] menuitem = menuitem_;

      // *** File ***

      if (item == menuitem [MenuDef.M_Open])
      {
        scene_.openFile ();
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_OpenLocation])
      {
 	scene_.openLocation ();
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_Reload])
      {
        if (scene_.reloadFile ())
          scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_CameraInfo])
      {
        scene_.getCamera ().printValues (System.out);
        return true;
      }
      if (item == menuitem [MenuDef.M_Exit])
      {
        dispose ();
        System.exit (0);
        return true;
      }

      // *** Navigate ***

      // navigation modes
      if (item == menuitem [MenuDef.M_Flip])
      {
        scene_.setNavigationMode (Scene.FLIP, Scene.UPDATE_ICON);
        scene_.redraw ();  // menu items may or may not cause expose
        return true;
      }
      if (item == menuitem [MenuDef.M_Walk])
      {
        scene_.setNavigationMode (Scene.WALK, Scene.UPDATE_ICON);
        scene_.redraw ();  // menu items may or may not cause expose
        return true;
      }
      // missing: fly
      if (item == menuitem [MenuDef.M_FlyTo])
      {
        scene_.setNavigationMode (Scene.FLYTO, Scene.UPDATE_ICON);
        scene_.redraw ();  // menu items may or may not cause expose
        return true;
      }
      if (item == menuitem [MenuDef.M_HeadsUp])
      {
        scene_.setNavigationMode (Scene.HEADSUP, Scene.UPDATE_ICON);
        scene_.redraw ();  // menu items may or may not cause expose
        return true;
      }

      // reset, level, untilt
      if (item == menuitem [MenuDef.M_ResetView])
      {
        scene_.resetView ();
        // menu items do not need to expose scene when closed
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_LevelView])
      {
        scene_.levelView ();
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_UntiltView])
      {
        scene_.untiltView ();
        scene_.redraw ();
        return true;
      }

      // *** Display ***

      // behavior
      if (item == menuitem [MenuDef.M_Behaviour])
      {
        scene_.toggleBehavior (Scene.UPDATE_ICON);
        if (scene_.behavior ())
          scene_.redraw ();
        return true;
      }

      // interaction
      if (item == menuitem [MenuDef.M_Interaction])
      {
        scene_.toggleInteraction (Scene.UPDATE_ICON);
        return true;
      }

      // drawing modes (redraw)
      if (item == menuitem [MenuDef.M_Wireframe])
      {
        scene_.drawingMode (GE3D.ge3d_wireframe, false);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_HiddenLine])
      {
        scene_.drawingMode (GE3D.ge3d_hidden_line, false);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_FlatShading])
      {
        scene_.drawingMode (GE3D.ge3d_flat_shading, false);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_SmoothShading])
      {
        scene_.drawingMode (GE3D.ge3d_smooth_shading, false);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_Texturing])
      {
        scene_.drawingMode (GE3D.ge3d_texturing, false);
        scene_.redraw ();
        return true;
      }

      // interactive drawing modes (no redraw)
      if (item == menuitem [MenuDef.M_ITheSame])
      {
        scene_.drawingMode (-1, true);
        return true;
      }
      if (item == menuitem [MenuDef.M_IWireframe])
      {
        scene_.drawingMode (GE3D.ge3d_wireframe, true);
        return true;
      }
      if (item == menuitem [MenuDef.M_IHiddenLine])
      {
        scene_.drawingMode (GE3D.ge3d_hidden_line, true);
        return true;
      }
      if (item == menuitem [MenuDef.M_IFlatShading])
      {
        scene_.drawingMode (GE3D.ge3d_flat_shading, true);
        return true;
      }
      if (item == menuitem [MenuDef.M_ISmoothShad])
      {
        scene_.drawingMode (GE3D.ge3d_smooth_shading, true);
        return true;
      }
      if (item == menuitem [MenuDef.M_ITexturing])
      {
        scene_.drawingMode (GE3D.ge3d_texturing, true);
        return true;
      }

      // framerate
      if (item == menuitem [MenuDef.M_ShowFramerate])
      {
        scene_.toggleShowframerate ();
        return true;
      }

      // settings
      if (item == menuitem [MenuDef.M_Settings])
      {
        scene_.toggleSettings ();
        return true;
      }

      // line antialiasing
      if (item == menuitem [MenuDef.M_AALines])
      {
        scene_.toggleLineAntialiasing ();
        return true;
      }

      // texture antialiasing/mipmapping
      if (item == menuitem [MenuDef.M_AATexturesOff])
      {
        scene_.setTextureMipmapping (0);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_AATextures1])
      {
        scene_.setTextureMipmapping (1);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_AATextures2])
      {
        scene_.setTextureMipmapping (2);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_AATextures3])
      {
        scene_.setTextureMipmapping (3);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_AATextures4])
      {
        scene_.setTextureMipmapping (4);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_AATexturesOn])
      {
        scene_.setTextureMipmapping (5);
        scene_.redraw ();
        return true;
      }

      // lighting
      if (item == menuitem [MenuDef.M_LCon])
      {
        scene_.setLighting (Scene.TRISTATE_ON);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_LCauto])
      {
        scene_.setLighting (Scene.TRISTATE_AUTO);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_LCoff])
      {
        scene_.setLighting (Scene.TRISTATE_OFF);
        scene_.redraw ();
        return true;
      }

      // materials on/off
      if (item == menuitem [MenuDef.M_LCnoMat])
      {
        scene_.setMaterials (!scene_.materials ());
        scene_.redraw ();
        return true;
      }

      // texture lighting
      if (item == menuitem [MenuDef.M_LConText])
      {
        scene_.setTexLighting (!scene_.getTexLighting ());
        scene_.redraw ();
        return true;
      }

      // two sided polygons (!backfaceculling)
      if (item == menuitem [MenuDef.M_TSPon])
      {
        scene_.setBackfaceCulling (Scene.TRISTATE_OFF);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_TSPauto])
      {
        scene_.setBackfaceCulling (Scene.TRISTATE_AUTO);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_TSPoff])
      {
        scene_.setBackfaceCulling (Scene.TRISTATE_ON);
        scene_.redraw ();
        return true;
      }

      // transparency method
      if (item == menuitem [MenuDef.M_TPoff])
      {
        scene_.setTranspMethod (0);
        return true;
      }
      if (item == menuitem [MenuDef.M_TPstipple])
      {
        scene_.setTranspMethod (1);
        return true;
      }
      if (item == menuitem [MenuDef.M_TPblending])
      {
        scene_.setTranspMethod (2);
        return true;
      }

      // texture transparency
      if (item == menuitem [MenuDef.M_TPonText])
      {
        scene_.setTextureTransparency (!scene_.getTextureTransparency ());
        scene_.redraw ();
        return true;
      }

      // headlight
      if (item == menuitem [MenuDef.M_ViewingLight])
      {
        scene_.toggleHeadlight ();
        if (scene_.hasLightSource ())  // scenes w/o light sources always drawn with headlight
          scene_.redraw ();
        return true;
      }

      // colors
      if (item == menuitem [MenuDef.M_CChoose])
      {
        scene_.toggleColorChooser ();
        return true;
      }
      if (item == menuitem [MenuDef.M_CBGndBLACK])
      {
        scene_.setColor (Scene.COLBACKGROUND, 0x000000);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_CBGndGRAY])
      {
        scene_.setColor (Scene.COLBACKGROUND, 0x808080);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_CBGndLGRAY])
      {
        scene_.setColor (Scene.COLBACKGROUND, 0xcccccc);
        scene_.redraw ();
        return true;
      }
      if (item == menuitem [MenuDef.M_CBGndWHITE])
      {
        scene_.setColor (Scene.COLBACKGROUND, 0xffffff);
        scene_.redraw ();
        return true;
      }

      // *** Help ***
      if (item == menuitem [MenuDef.M_Overview])
      {
        scene_.showHelpfile ("index.html");
        return true;
      }
      if (item == menuitem [MenuDef.M_Homepage])
      {
        scene_.activateAnchor (VRwave.HOMEURL, null, 0);
        return true;
      }
      if (item == menuitem [MenuDef.M_About])
      {
        scene_.toggleAbout ();
        return true;
      }

    } // menu action

    return false;
  } // action

} // SceneFrame
