/*
 * CmdLineParser.java
 *
 * created: kwagen, 19970512
 *
 * changed: kwagen, 19970520
 *
 * $Id: CmdLineParser.java,v 1.2 1997/08/01 18:29:40 mpichler Exp $
 */


package iicm.vrml.vrwave;

// CmdLineParser - command line parser
// compare with getargs.C of hyperg/src/common/utils

public class CmdLineParser
{
  public final static int UNKNOWN_OPTION = -1;
  public final static int OTHER_ARGUMENT = -2;
  public final static int NO_MORE_ARGS = -3;

  private String[] options_;
  private int[] tags_;
  private int argc_;
  private String[] argv_;
  private int cur_ = -1;

  public CmdLineParser (String[] argv, String[] options, int[] tags)
  {
    options_ = options;
    tags_ = tags;
    argc_ = argv.length;
    argv_ = argv;
  }

  public boolean more ()
  { return (cur_+1 < argc_); }

  public int getNext ()
  {
    if (!(++cur_ < argc_))
      return NO_MORE_ARGS;

    String curarg = argv_ [cur_];

    if (options_ != null)
      for (int i = 0; i < options_.length; i++)
        if (curarg.equals (options_[i]))
          return tags_[i];

    if (curarg.startsWith ("-"))
      return UNKNOWN_OPTION;

    return OTHER_ARGUMENT;
  }

  public String currentArgString ()
  {
    return (cur_ < argc_) ? argv_[cur_] : null;
  }

  public String nextArgString ()
  {
    return (++cur_ < argc_) ? argv_[cur_] : null;
  }
} // CmdLineParser
