/*
 * <copyright>
 *
 * Copyright (c) 1996,97
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the `pw' VRML 2.0 parser.
 *
 * </copyright>
 */
/*
 * ProtoInstance.java - instance of a PROTO node
 *
 * created: mpichler, 19961001
 * changed: mpichler, 19970108
 *
 * $Id: ProtoInstance.java,v 1.5 1997/05/22 16:11:45 apesen Exp $
 */


package iicm.vrml.pw; 

import java.io.*;
import java.util.*;


/**
 * ProtoInstance - instance of PROTO or EXTERNPROTO node
 * Copyright (c) 1996,97 IICM
 *
 * @author Michael Pichler, Karin Roschker
 * @version 0.1, changed:  8 Jan 97
 */

public class ProtoInstance extends Node
{
  ProtoNode bap;  // the PROTO node that describes this instance

  // TODO: for traversal of this PROTO instance we need a copy
  // of the children of the PROTO node with the current field values

  public String nodeName ()
  {
    return bap.protoname;
  }

  public void traverse (Traverser t)
  {
    t.tProtoInstance (this);
  }

  ProtoInstance (ProtoNode parent)
  {
    // parent should be non-null
    bap = parent;

    // create a copy of each protofield
    // (subfields = parent.protofields; would overwrite proto fields)
    Hashtable bapfields = parent.protofields;
    Enumeration e = bapfields.keys ();
    while (e.hasMoreElements ())
    {
      String fname = (String) e.nextElement ();
      Field f = (Field) bapfields.get (fname);
      subfields.put (fname, f.newFieldInstance ());
    }
  }

  // the current implementation allows reading the fields
  // and writes them back to the output (writeNode works)

  // for efficient traversal of the nodes,
  // a copy of the children subtree will have to be made,
  // where protofields (protoISfield refers to bap's field)
  // are substituted by the field values of this instance

} // ProtoInstance
