.TH scicos_cpr  "Janvier 1997" "Scilab Group" "Scicos data structure"
.so ../sci.an
.SH NAME
scicos_cpr - Scicos compiled diagram data structure
.SH DEFINITION
.nf
cpr=list(state,sim,cor,corinv)
.fi
.SH PARAMETERS
.TP 10
state
: Scilab \fVtlist\fR contains  initial state. 
.RS
.TP 15
state('x')
: continuous  state vector. 
.TP
state('z')
: discrete  state vector. 
.TP
state('tevts')
: vector of  event dates
.TP
state('evtspt')
: vector of event pointers
.TP
state('pointi')
: pointer to next event
state('npoint')
: not used yet
state('outtb')
: vector of inputs/outputs initial values.
.RE
.TP
sim
: Scilab \fVtlist\fR.  Usually generated by Scicos
\fVCompile\fR menu. Some useful entries are:
.RS
.TP 15
sim('rpar')
: vector of blocks' floating point parameters
.TP
sim('rpptr')
: (nblk+1) x 1 vector of integers, 

 \fVsim('rpar')(rpptr(i):(rpptr(i+1)-1))\fR is the vector of floating
point parameters of the \fVi\fRth block. 
.TP
sim('ipar')
: vector of blocks' integer parameters
.TP
sim('ipptr')
: (nblk+1) x 1 vector of integers, 

 \fVsim('ipar')(ipptr(i):(ipptr(i+1)-1))\fR is the vector of integer
parameters of the \fVi\fRth block. 
.TP
sim('funs')
: vector of strings containing the names of each block simulation function
.TP
sim('xptr')
: (nblk+1) x 1 vector of integers, 

 \fVstate('x')(xptr(i):(xptr(i+1)-1))\fR is the continuous state
vector  of the \fVi\fRth block. 
.TP
sim('zptr')
: (nblk+1) x 1 vector of integers, 

 \fVstate('z')(zptr(i):(zptr(i+1)-1))\fR is the discrete state
vector  of the \fVi\fRth block. 
.TP
sim('inpptr')
: (nblk+1) x 1 vector of integers, 

\fVinpptr(i+1)-inpptr(i)\fR gives
the number of input ports. \fVinpptr(i)\fRth points to the
beginning of \fVi\fRth block inputs  within the indirection table \fVinplnk\fR.
.TP
sim('inplnk')
: nblink x 1 vector of integers, 

\fVinplnk(inpptr(i)-1+j)\fR is the
index of the link connected to the  \fVj\fRth input port of the \fVi\fRth block.
where \fVj\fR goes from \fV1\fR to \fVinpptr(i+1)-inpptr(i))\fR.
.TP
sim('outptr')
: (nblk+1) x 1 vector of integers, 

\fVoutptr(i+1)-outptr(i)\fR gives
the number of output ports. \fVoutptr(i)\fRth points to the
beginning of \fVi\fRth block outputs  within the indirection table \fVoutlnk\fR.
.TP
sim('outlnk')
: nblink x 1 vector of integers,

 \fVoutlnk(outptr(i)-1+j)\fR is the
index of the link connected to the  \fVj\fRth output port of the \fVi\fRth block.
where \fVj\fR goes from \fV1\fR to \fVoutptr(i+1)-outptr(i))\fR.
.TP
sim('lnkptr')
: (nblink+1) x 1 vector of integers, 

\fVk\fRth  entry points to the
beginning of region  within \fVouttb\fR dedicated to link indexed \fVk\fR.
.TP
sim('funs')
: vector of strings containing the names of each block simulation function
.TP
sim('funtyp')
: vector of  block block types.
.RE
.TP
cor    
: is a list with same recursive structure as scs_m each leaf 
contains the index of associated block in \fVcpr\fR data structure.
.TP
corinv 
: corinv(i) is the path of \fVi\fR th block defined in \fVcpr\fR data structure
          in the \fVscs_m\fR data structure.

.SH DESCRIPTION
Scicos compiled diagram data structure contains all information needed
to simulate the system (see  \fVscicosim\fR). 
.SH SEE ALSO
scicos,  scicos_model, scicos_main, scicosim







