.TH pvm_joingroup 1 "May 1998" "Scilab // Group" "Scilab function"
.so ../sci.an
.SH NAME
pvm_joingroup - enrolls the calling process in a named group.
.SH CALLING SEQUENCE
.nf
[inum] = pvm_joingroup(group)
.fi
.SH PARAMETERS
.TP 5
group
: string, string group name of an existing group.
.TP 4
inum
: integer, instance number returned by the routine.
.SH DESCRIPTION
\fVpvm_joingroup\fR 
enrolls the calling task in
the group named
.I group
and returns the instance number
.I inum
of this task in this group.
If there is an error
.I inum
will be negative.
.PP
Instance numbers start at 0 and count up.
When using groups a (group, inum) pair uniquely identifies a
PVM process.
This is consistent with the PVM 2.4 naming schemes.
If a task leaves a group by calling pvm_lvgroup
and later rejoins the same group,
the task is not guaranteed to get the same instance number.
PVM attempts to reuse old instance numbers, so when a task
joins a group it will get the lowest available instance number.
A task can be a member of multiple groups simultaneously.

.SH EXAMPLE
.nf
inum =  pvm_joingroup( "worker" )
.fi
.SH SEE ALSO
pvm_lvgroup


