.TH pvm_getinst 1 "May 1998" "Scilab // Group" "Scilab function"
.so ../sci.an
.SH NAME
pvm_getinst - returns the instance number in a group of a PVM process.
.SH CALLING SEQUENCE
.nf
[inum] = pvm_getinst(group, tid)
.fi
.SH PARAMETERS
.TP 5
group
: string, string group name of an existing group.
.TP 4
tid
: integer, task identifier of a PVM process.
.TP 4
inum
: integer, instance number returned by the routine.
.SH DESCRIPTION
\fVpvm_getinst\fR 
takes a group name
.I group
and a PVM task identifier
.I tid
and returns the unique
instance number that corresponds to the input.
It can be called by any task whether in the group or not.
If pvm_getinst is successful,
.I inum
will be >= 0.
If some error occurs then
.I inum
will be < 0.

.SH EXAMPLE
.nf
inum = pvm_getinst( "worker", pvm_mytid() )
.fi
.SH SEE ALSO
pvm_joingroup, pvm_gettid
