.TH max_cap_path 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
max_cap_path - maximum capacity path
.SH CALLING SEQUENCE
.nf
[p,cap] = max_cap_path(i,j,g)
.fi
.SH PARAMETERS
.TP 4
i,j
: integers, node numbers
.TP 2
g
: graph list
.TP 2
p
: row vector of integer numbers of the arcs of the path if it exists
.TP 4
cap
: value of the capacity of the path
.SH DESCRIPTION
\fVmax_cap_path\fR returns the path with maximum capacity from node
\fVi\fR to node \fVj\fR for the graph \fVg\fR if it exists and returns 
the empty vector \fV[]\fR otherwise.

The capacities of the edges are given by the element \fVedge_max_cap\fR
of the graph list. If its value is not given (empty vector \fV[]\fR), 
\fVmax_cap_path\fR returns the empty vector \fV[]\fR.
The capacities must be strictly positive, i.e negative capacities
are considered as equal to 0 (no capacity at all).
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 15 12 13 9 10 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
show_graph(g);
ma=edge_number(g);
g('edge_max_cap')=int(rand(1,ma)*16)+5;
[p,cap]=max_cap_path(1,14,g);
edgecolor=1*ones(1,ma); edgecolor(p)=11*ones(p); g('edge_color')=edgecolor;
x_message(['The maximum capacity is: '+string(cap);
           'Showing the corresponding path']);
show_graph(g); show_arcs(p);
.fi
