.TH hamilton 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
hamilton - hamiltonian circuit of a graph
.SH CALLING SEQUENCE
.nf
cir = hamilton(g)
.fi
.SH PARAMETERS
.TP 2
g
: graph list 
.TP 4
cir
: integer row vector
.SH DESCRIPTION
\fVhamilton\fR finds an hamiltonian circuit (if it exists) of the directed
graph \fVg\fR.
.SH EXAMPLE
.nf
ta=[2  1 3 2 2 4 4 5 6 7 8 8 9 10 10 10 10 11 12 13 13 14 15 16 16 17 17];
he=[1 10 2 5 7 3 2 4 5 8 6 9 7 7 11 13 15 12 13  9 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
g('node_diam')=[1:(g('node_number'))]+20;
show_graph(g);
cir=hamilton(g)
show_arcs(cir);
.fi
