.TH con_nodes 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
con_nodes - set of nodes of a connected component
.SH CALLING SEQUENCE
.nf
ns = con_nodes(i,g)
.fi
.SH PARAMETERS
.TP 2
i
: integer, number of the connected component
.TP 2
g
: graph list
.TP 3
ns
: row vector, node numbers of the connected component
.SH DESCRIPTION
\fVcon_nodes\fR returns the row vector \fVns\fR of the numbers of the
nodes which belong to the connected component number \fVi\fR.
If \fVi\fR is not the number of a connected component, the empty vector
\fV[]\fR is returned.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 4 5 7 7 9 10 12 12 13 13 14 15];
he=[2 6 3 4 5 1 3 5 1 8 9 8 11 10 11 11 15 13 14];
g=make_graph('foo',1,15,ta,he);
g('node_x')=[197 191 106 194 296 305 305 418 422 432 552 550 549 416 548];
g('node_y')=[76 181 276 278 276 83 174 281 177 86 175 90 290 397 399];
show_graph(g);
con_nodes(2,g)
x_message('Displaying the nodes of component #2');
n=g('node_number');
nodecolor=0*ones(1,n);
nodecolor(1,con_nodes(2,g))=11*ones(con_nodes(2,g));
g('node_color')=nodecolor;
nodediam=20.*ones(1,n);
nodediam(1,con_nodes(2,g))=30*ones(con_nodes(2,g));
g('node_diam')=nodediam;
show_graph(g);
.fi
.SH SEE ALSO
connex, is_connex, strong_connex, strong_con_nodes
