.TH circuit 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
circuit - finds a circuit or the rank function in a directed graph
.SH CALLING SEQUENCE
.nf
[p,r] = circuit(g)
.fi
.SH PARAMETERS
.TP 2
g
: graph list
.TP 2
p
: row vector of integer numbers of the arcs of the circuit if it exists
.TP 2
r
: row vector of rank function if there is no circuit
.SH DESCRIPTION 
\fVcircuit\fR tries to find a circuit for the directed graph \fVg\fR.
It returns the circuit \fVp\fR as a row vector of the
corresponding arc numbers if it exists and it returns the empty vector \fV[]\fR
otherwise.
If the graph has no circuit, the rank function is returned in \fVr\fR, 
otherwise its value is the empty vector \fV[]\fR.
.SH EXAMPLE
.nf
// graph with circuit
ta=[1 1 2 3 5 4 6 7 7 3 3 8 8 5];
he=[2 3 5 4 6 6 7 4 3 2 8 1 7 4];
g=make_graph('foo',1,8,ta,he);
g('node_x')=[116 231 192 323 354 454 305 155];
g('node_y')=[ 118 116 212 219 117 185 334 316];
show_graph(g);
p=circuit(g)
show_arcs(p)
// graph without circuit
g=make_graph('foo',1,4,[1 2 2 3],[2 3 4 4]);
[p,r]=circuit(g)
.fi
