.TH "oscillsing" 2 " June 6th 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
oscillsing - Oscillating Singularity synthesis
.sp
Author: Paulo Goncalves 
.sp
Generates oscillating singularities located in the interval \f(CR[\fP0 .. 1\f(CR]\fP
.sp
.sp
.SH Usage
\f(CR[\fPx,Fj,Fs\f(CR]\fP = oscillsing(alpha,beta,sing_pos,N,show) ;
.SH Input parameters


.RS

.TP
o 
\fB alpha \fP : Real positive vector \f(CR[\fP1,n_sing\f(CR]\fP or \f(CR[\fPn_sing,1\f(CR]\fP 
Holder strenghts of the singularities

.TP
o 
\fB beta \fP : Real positive vector \f(CR[\fP1,n_sing\f(CR]\fP or \f(CR[\fPn_sing,1\f(CR]\fP 
Chirp exponents of the singularities

.TP
o 
\fB sing_pos \fP : Real vector \f(CR[\fP1,n_sing\f(CR]\fP or \f(CR[\fPn_sing,1\f(CR]\fP 
Location of the singularities in the interval  \f(CR[\fP0 .. 1\f(CR]\fP

.TP
o 
\fB N \fP : Integer
Sample size for the synthesized signal

.TP
o 
\fB show \fP : flag 0/1
\fI flag \fP = 0 : no display  
\fI flag \fP = 1 : displays the instantaneous frequencies and the
synthesized signal
.RE

.SH Output parameters


.RS

.TP
o 
\fB x \fP : real vector  \f(CR[\fP1,N\f(CR]\fP 
Time samples of the synthesized signal

.TP
o 
\fB Fj \fP : real matrix \f(CR[\fPN,n_sing\f(CR]\fP 
instantaneous frequencies (each column of \fIFj\fP contains the
frequency chirp of each singularity)

.TP
o 
\fB Fs \fP : real 
sampling frequency
.RE

.SH See also:
.SH Example:
\f(CR[\fPx,Fj,Fs\f(CR]\fP = oscillsing(\f(CR[\fP1/2 1 2\f(CR]\fP,\f(CR[\fP1 2 4\f(CR]\fP,\f(CR[\fP-0.5 0 0.5\f(CR]\fP,256,1) ;
