.TH addmenu 3 "December 1995" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
addmenu - interactive button or menu definition
.SH CALLING SEQUENCE
.nf
addmenu(button [,submenus] [,action]) 
addmenu(gwin,button [,submenus] [,action]) 
.fi
.SH PARAMETERS
.TP 10
button
: a character string. The button name
.TP
submenus
: a vector of character string. The sub_menus items names
.TP
action
: a list with 2 elements action=list(flag,proc_name)
.RS
.TP 10
flag
: an integer (default value is 0)
.RS
.TP 15
flag==0
: the action is defined by a scilab instruction
.TP
flag==1
: the action is defined by a C or Fortran procedure
.RE
.TP
proc_name
: a character string which gives the name of scilab variable
containing the instruction or the name of procedure to call.
.RE
.TP
gwin
: integer. The number of graphic window where the button is required
to be installed
.SH DESCRIPTION
The function allows the user to add new buttons or menus in the main
window or graphics windows command panels.

If \fVaction\fR is not given the action associated with a button must
be defined by a scilab instruction given by the character string
variable which name is  
.TP 20
button
for a main window command
.TP
button_gwin
for a graphic window command

If \fVproc_name\fR designes a C or Fortran procedure, this procedure
may be interfaced in Fortran subroutine default/fbutn.f or dynamically
linked with scilab using the \fVlink function\fR.

.LP
Actions associated with the kth sub_menu must be defined by  scilab
instructions stored in the kth element of the character string
variable which name is  
.TP 20
button
for a main window command
.TP
button_gwin
for a graphic window command
.SH EXAMPLE
.nf
addmenu('foo')
foo='disp(''hello'')'

addmenu('Hello',['Franck';'Peter'])
Hello=['disp(''hello Franck'')';'disp(''hello Peter'')']

addmenu(0,'Hello',['Franck';'Peter'])
Hello_0=['disp(''hello Franck'')';'disp(''hello Peter'')']

addmenu('Bye',list(0,'French_Bye'))
French_Bye='disp(''Au revoir'')'
.fi
.SH SEE ALSO
setmenu, unsetmenu, delmenu
