/* Error codes */

#define DLD_ENOFILE	1		/* cannot open file */
#define DLD_EBADMAGIC	2		/* bad magic number */
#define DLD_EBADHEADER	3		/* failure reading header */
#define DLD_ENOTEXT	4		/* premature eof in text section */
#define DLD_ENOSYMBOLS	5		/* premature end of file in symbols */
#define DLD_ENOSTRINGS	6		/* bad string table */
#define DLD_ENOTXTRELOC	7		/* premature eof in text relocation */
#define DLD_ENODATA	8		/* premature eof in data section */
#define DLD_ENODATRELOC	9		/* premature eof in data relocation */
#define DLD_EMULTDEFS	10		/* multiple definitions of symbol */
#define DLD_EBADLIBRARY	11		/* malformed library archive */
#define DLD_EBADCOMMON	12		/* common block not supported */
#define DLD_EBADOBJECT	13		/* malformed input file (not rel or
					   archive) */
#define DLD_EBADRELOC	14		/* bad relocation info */
#define DLD_ENOMEMORY	15		/* virtual memory exhausted */
#define DLD_EUNDEFSYM	16		/* undefined symbol */

extern int dld_errno;			/* error code returned by dld */
extern int dld_undefined_sym_count; /* # of undefined global symbols */

extern int dld_init (char *);			/* initialize the dld routines */
extern int dld_link (char *);			/* dynamically link and load an object
					   file */
extern unsigned long
dld_get_symbol (char *);			/* return the address of the named
					   identifier  */
extern unsigned long
dld_get_func (char *);			/* return the address of the named
					   function */
extern unsigned long
dld_get_bare_symbol (char *);			/* same as dld_get_symbol except that
					   no underscore (_) is prepended.  Use
					   to locate symbols defined by
					   assembly routines. */
extern int dld_unlink_by_file (char *, int);   /* unlink a file */
extern int dld_unlink_by_symbol (char *, int); /* unlink the module that define the
					   given symbol */

extern int
dld_function_executable_p (char *);		/* return true if the named C function
					   is executable */

extern char **
dld_list_undefined_sym (void);		/* return an array of undefined symbols */

extern char *
dld_find_executable (char *);			/* return the full path name of the
					   given executable file. */

extern int
dld_create_reference (char *);		/* explicitly create a reference to the
					   given symbol. */

extern int dld_define_sym (char *, unsigned int);		/* explicitly define the value for the
					   given symbol. */

extern void
dld_remove_defined_symbol (char *);		/* remove a explicitly defined symbol */

extern void dld_perror (char *);		/* print error messages. */

extern char *dld_strerror (int);		/* returns the error message */
