/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLbaseName (const char Fname[], char Bname[])

Purpose:
  Return the last component of a file path

Description:
  This routine takes a file path specification and returns the rightmost
  component.  Components are separated by / characters.  If no / character
  appears in the path, the input path name is returned.  For MS-DOS, the
  directory separator character is \.

Parameters:
  <-  int FLbaseName
      Number of characters in the output string
   -> const char Fname[]
      Input character string with the path name
  <-  char Bname[]
      Output string with the last path name component.  This string is at most
      FILENAME_MAX characters long including the terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.16 $  $Date: 1997/10/14 14:33:20 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLbaseName.c 1.16 1997/10/14 libtsp-v3r0 $";

#include <string.h>

#include <libtsp.h>
#include <libtsp/Xstdio.h>	/* FILENAME_MAX */
#include <libtsp/sysOS.h>

#ifdef MSDOS
#  ifndef unix
#    define MSDOS_SEP
#  endif
#endif

#ifdef MSDOS_SEP
#  define DIR_SEP_CHAR		'\\'
#else
#  define DIR_SEP_CHAR		'/'
#endif


int
FLbaseName (Fname, Bname)

     const char Fname[];
     char Bname[];

{
  char *p;
  int n;

  p = strrchr (Fname, DIR_SEP_CHAR);
  if (p != NULL)
    n = STcopyMax (p+1, Bname, FILENAME_MAX-1);
  else
    n = STcopyMax (Fname, Bname, FILENAME_MAX-1);

  return n;
}
