/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  long int AFtell (FILE *fp, int *ErrCode)

Purpose:
  Determine the position in a file

Description:
  This routine returns the position in a file.

Parameters:
  <-  long int AFtell
      Position in the file relative to the start of the file
   -> FILE *fp
      File pointer associated with the file
  <-> int ErrCode
      Error code.  This value is set if an error is detected, but otherwise
      remains unchanged.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.6 $  $Date: 1997/10/14 13:57:29 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFtell.c 1.6 1997/10/14 libtsp-v3r0 $";

#include <errno.h>

#include <libtsp.h>
#include <libtsp/AFdataio.h>
#include <libtsp/AFmsg.h>
#include <libtsp/AFpar.h>


long int
AFtell (fp, ErrCode)

     FILE * fp;
     int *ErrCode;

{
  long int pos;

  pos = -1L;
  if (! *ErrCode) {
    errno = 0;
    pos = ftell (fp);
    if (pos == -1L && errno) {
      UTsysMsg ("AFtell: %s", AFM_NoFilePos);
      *ErrCode = AF_IOERR;
    }
  }

  return pos;
}
