namespace eval gui {
    variable gui

    # Define the fonts used for the Widget labels.
    switch $tkWorld(ostype) {
	windows {
	    set gui(font.label) {helvetica 10 bold}
	}
	default {
	    set gui(font.label) {helvetica 12 bold}
	}
    }
}

# gui::create --
#
#   Method to build the application's GUI components
#
# Args
#
#   None
#
# Returns
#
#   None

proc gui::create { } {
    global tkWorld
    variable gui

    # Create the main widgets that tkWorld will use.
    set tkWorld(toolbar) [toolbar::create .toolbar]
    set tkWorld(cmd_center) [scroll_text::interior \
	    [scroll_text::create .cmd_center 70 5]]
    set tkWorld(log_window) [scroll_text::interior \
	    [scroll_text::create .log_window 70 25]]
    set tkWorld(reg_listbox) [scroll_listbox::interior \
	    [scroll_listbox::create .reg_listbox 8]]

    # Create the GUI components for the shell, working directory
    # drop down list boxes, and the background process indicator.
    set top [frame .top]
    set wd_label [label $top.label_wd \
	    -text "Dir" \
	    -anchor w]
    set wd_entry [entry $top.entry_wd \
	    -width 50 \
	    -textvariable tkWorld(working_dir)]
    set tkWorld(working_dir_entry) $wd_entry
    set dir_button [button $top.button_dir \
	    -text "dir" \
	    -width 1 \
	    -relief flat \
	    -command [list wdir::contents::list dir]]
    set ls_button [button $top.button_ls \
	    -text "ls" \
	    -width 1 \
	    -relief flat \
	    -command [list wdir::contents::list ls]]
    set cd_button [button $top.button_cd \
	    -text "cd" \
	    -width 1 \
	    -relief flat \
	    -command wdir::create]
    pack $dir_button $ls_button $cd_button $wd_entry \
	    -side left \
	    -padx 0 \
	    -pady 0
    #pack $wd_entry $wd_label \
	    -side left \
	    -padx 2 \
	    -pady 0
    pack [seperator::create $top.sep2 sunken] \
	    -side left \
	    -padx 5 \
	    -pady 0 \
	    -fill y
    set shell_label [label $top.shell_label \
	    -text "Shell"]
    set shell_entry [ddlistbox::create $top tkWorld(working_shell) \
	    "sh bash ksh pdksh csh tcsh ash zsh" 5]
    pack $shell_label $shell_entry \
	    -side left \
	    -padx 2 \
	    -pady 0
    pack [seperator::create $top.sep1 sunken] \
	    -side left \
	    -padx 5 \
	    -pady 0 \
	    -fill y
    set bg_checkbutton [checkbutton $top.bg_checkbutton \
	    -text "Background" \
	    -variable cmd_center::cmd_center(bgproc)]
    pack $bg_checkbutton \
	    -side left \
	    -padx 2 \
	    -pady 0 \
	    -fill x

    # Make the dir button raise and lower on mouse entry/leave.
    bind $dir_button <Enter> "$dir_button configure -relief raised"
    bind $dir_button <Leave> "$dir_button configure -relief flat"
    bind $ls_button <Enter> "$ls_button configure -relief raised"
    bind $ls_button <Leave> "$ls_button configure -relief flat"
    bind $cd_button <Enter> "$cd_button configure -relief raised"
    bind $cd_button <Leave> "$cd_button configure -relief flat"

    # Define the balloon help messages for the executing shell and
    # the working directory components.
    balloonhelp::for $shell_label "Execute commands using this shell"
    balloonhelp::for $shell_entry "Change the executing shell"
    balloonhelp::for $wd_label "The current working directory"
    balloonhelp::for $wd_entry "The current working directory"
    balloonhelp::for $dir_button "Display the directory listing for\
	    the current working directory"
    balloonhelp::for $ls_button "Display the long format listing for\
	    the current working directory"
    balloonhelp::for $cd_button "Open the Change Working Directory\
	    Dialog to select a new working directory"
    balloonhelp::for $bg_checkbutton "Execute the current command\
	    in the background"

    # Put all of the widgets in a grid.  Note row 0 is
    # the menubar.
    grid .toolbar \
	    -row 1 \
	    -column 0 \
	    -columnspan 3 \
	    -sticky ew
    grid [set tkWorld(seperator_1) [seperator::create .s1]] \
	    -row 2 \
	    -column 0 \
	    -columnspan 3 \
	    -sticky ew
    grid $top \
	    -row 3 \
	    -column 0 \
	    -columnspan 3 \
	    -sticky ew
    grid [seperator::create .s2] \
	    -row 4 \
	    -column 0 \
	    -columnspan 3 \
	    -sticky ew
    grid [label .reg_label \
	    -text Registry \
	    -font $gui(font.label)] \
	    -row 5 \
	    -column 0 \
	    -sticky ew
    grid .reg_listbox \
	    -row 6 \
	    -column 0 \
	    -rowspan 4 \
	    -sticky news
    grid [seperator::create .s3] \
	    -row 5 \
	    -column 1 \
	    -rowspan 5 \
	    -sticky ns
    grid [label .cc_label \
	    -text "Command Center" \
	    -font $gui(font.label)] \
	    -row 5 \
	    -column 2 \
	    -sticky ew
    grid .cmd_center \
	    -row 6 \
	    -column 2 \
	    -sticky news
    grid [seperator::create .s4] \
	    -row 7 \
	    -column 2 \
	    -pady 2 \
	    -sticky ew
    grid [label .lw_label \
	    -text "Log Window" \
	    -font $gui(font.label)] \
	    -row 8 \
	    -column 2 \
	    -sticky ew
    grid .log_window \
	    -row 9 \
	    -column 2 \
	    -sticky news

    # Configure the rows to expand accordingly.
    grid rowconfigure . 1 \
	    -weight 0
    grid rowconfigure . 3 \
	    -weight 0
    grid rowconfigure . 4 \
	    -weight 0
    grid rowconfigure . 6 \
	    -weight 1
    grid rowconfigure . 7 \
	    -weight 0
    grid rowconfigure . 9 \
	    -weight 1

    # Configure the columns to expand accordingly.
    grid columnconfigure . 0 \
	    -weight 0
    grid columnconfigure . 1 \
	    -weight 0
    grid columnconfigure . 2 \
	    -weight 1

    # Put the user at the CC.
    focus $tkWorld(cmd_center)

    # Put all the available commands in the listbox.
    registry::create

    # Now the other elements are defined, set up the menubar.
    set tkWorld(menubar) [menubar::create .menubar]

    # If the user clicks into these LW and CC widgets, activate the
    # toolbar button group associated with that widget.
    bind $tkWorld(cmd_center) <FocusIn> \
	    {toolbar::group_state cmd_center active; \
	    toolbar::button_state $toolbar::toolbar(stop) disabled}
    bind $tkWorld(log_window) <FocusIn> \
	    {toolbar::group_state log_window active}

    # Setup keyboard bindings for all of the commands available
    # in the CC.
    bind $tkWorld(cmd_center) <Control-z> cmd_center::stop
    bind $tkWorld(cmd_center) <Control-x> cmd_center::run
    bind $tkWorld(cmd_center) <Control-c> cmd_center::reset
    bind $tkWorld(cmd_center) <Control-s> cmd_center::shell
    bind $tkWorld(cmd_center) <Control-p> {history::get end}
    bind $tkWorld(cmd_center) <Control-m> history::create
    bind $tkWorld(cmd_center) <Control-j> \
	    [list focus $tkWorld(log_window)]

    # Setup keyboard bindings for all of the commands available
    # in the LW.
    #bind $tkWorld(log_window) <Control-Key-home> log_window::home
    #bind $tkWorld(log_window) <Control-Key-end> log_window::end
    bind $tkWorld(log_window) <Escape> log_window::up
    bind $tkWorld(log_window) <Control-v> log_window::down
    bind $tkWorld(log_window) <Control-c> log_window::clear
    bind $tkWorld(log_window) <Control-s> log_window::save
    bind $tkWorld(log_window) <Control-j> \
	    [list focus $tkWorld(cmd_center)]

    # Configure the window manager for unix systems.
    switch $tkWorld(ostype) {
	unix {
	    wm title . "tkWorld User: $tkWorld(user)"
	    wm iconbitmap . \
		    @[file join $tkWorld(image_dir) tkWorld.ic.xbm]
	}
    }
}
