/**************************************************************
  (C) 1998 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <stdlib.h>
#include "gtkhelp.h"
#include "iwc.h"
#include "iconmanager.h"
#include "global.h"

void xinputcall( gpointer data, gint source, GdkInputCondition condition)
{
  XEvent event;
  while (XEventsQueued(GetDisplay(),QueuedAfterReading)!=0) {
    XNextEvent(GetDisplay(),&event);
    if (event.type==EnterNotify && event.xcrossing.window==GetWindow() && 
        GetIsDesktop()==True) {
      XLowerWindow(GetDisplay(),GetWindow());
      LowerIcons();
      ManageAutofocus(&event);
    }
    if (event.type==Expose) {
      if (GetIsDesktop()==True) {
	XLowerWindow(GetDisplay(),GetWindow());
	LowerIcons();
      } else
        UpdateDetailView(event.xexpose.window);
    }
  }
  XFlush(GetDisplay());
}

void mygtk_main()
{
  XFlush(GetDisplay());
  gdk_input_add( ConnectionNumber(GetDisplay()),
  GDK_INPUT_READ ,
  ( xinputcall),NULL);
  gtk_main();
}

GtkWidget* mygtk_setwindowsize(GtkWidget* window,int x,int y)  
{
    GtkWidget* table;
    
    gtk_widget_set_usize( window,x,y );
    table = gtk_table_new (x, y, FALSE);
    gtk_table_set_row_spacings( GTK_TABLE(table),1);
    gtk_table_set_col_spacings( GTK_TABLE(table),1);
    gtk_container_add (GTK_CONTAINER (window), table);
    return table;
}

void mygtk_show_window(GtkWidget* win,GtkWidget* table,char* title)
{
  gtk_window_set_title(GTK_WINDOW(win),title);
  gtk_window_position(GTK_WINDOW(win),GTK_WIN_POS_CENTER);
  gtk_widget_show(table);
  gtk_widget_show(win);
}

void mygtk_setposition(GtkWidget* table,GtkWidget* child,int x,int y,int sx,int sy)
{
    gtk_table_attach (GTK_TABLE(table), child, x,x+sx,y,y+sy ,
	  GTK_FILL/*|GTK_EXPAND*/,GTK_FILL/*|GTK_EXPAND*/,0,0);
    gtk_widget_set_uposition(child,x,y);
    gtk_widget_set_usize(child,sx,sy);

          gtk_widget_show (child);
}

GtkWidget* mygtk_colorselect_new(char* txtcolor,char *text)  
{
  gdouble color[3];
  GtkWidget* colsel;
  int r,g,b;
  
  if (txtcolor!=NULL && txtcolor[0]=='#' && txtcolor[1]==' ')
      sscanf(txtcolor,"# %d %d %d",&r,&g,&b);
    else {
      r=255;g=255;b=255;
    }
  color[0]=r/255.0;
  color[1]=g/255.0;
  color[2]=b/255.0;
  colsel=gtk_color_selection_dialog_new(text);
  gtk_color_selection_set_color(GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colsel)->colorsel),color);
  gtk_widget_hide(GTK_COLOR_SELECTION_DIALOG(colsel)->help_button);
  gtk_widget_show(colsel);
  
  return colsel;
}

void mygtk_getcolor(GtkWidget* colsel,char **oldnew)
{
  gdouble color[3];
  int r,g,b;
  gtk_color_selection_get_color(GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colsel)->colorsel),color);
  r = (int)(color[0]*255.0);
  g = (int)(color[1]*255.0);
  b = (int)(color[2]*255.0);
  free(*oldnew);
  *oldnew=malloc(20);
  sprintf(*oldnew,"# %d %d %d",r,g,b);
}

GtkWidget* mygtk_fileselect_new(char *text,char *filename) 
{
  GtkWidget* filsel;
  
  filsel=gtk_file_selection_new(text);
  if (filename!=NULL && filename[0]!='#')
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(filsel),filename);
  gtk_widget_show(filsel);
  /*gtk_widget_hide(GTK_FILE_SELECTION(filsel)->help_button)*/;

  return filsel;
}
