/* 
   FTP client implementation
   Copyright (C) 1998, Joe Orton <joe@orton.demon.co.uk>
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef FTP_H
#define FTP_H

#include "sites.h"
#include "protocol.h"

/* This module contains an FTP client implementation.
 * Simple to use:
 *   ftp_init( "host.name.co.uk", 21, "username", "password" );
 *   ftp_mkdir( "/asda/" ); ftp_rmdir( "/norman" );
 *   ftp_finish( );
 * All commands return FTP_OK on success.
 */

/* Configuration items:
 * ftp_use_passive :- use passive mode if true.
 * ftp_force_cwd :- always cwd and never use paths in filenames
 */

extern bool ftp_use_passive;
extern bool ftp_force_cwd;

/* Error reporting buffer */
extern char ftp_error[];

/* Connection functions */
int ftp_init( const char *remote_root, struct proto_host_t *server,
	      struct proto_host_t *proxy );
int ftp_finish( void );

/* The commands available */
int ftp_put( const char *localfile, const char *remotefile, const bool ascii );
int ftp_get( const char *localfile, const char *remotefile,
	     const int remotesize, const bool ascii );
int ftp_delete( const char *filename );
int ftp_rmdir( const char *dir );
int ftp_mkdir( const char *dir );
int ftp_chmod( const char *filename, const mode_t mode );
int ftp_move( const char *from, const char *to );
int ftp_fetch( const char *startdir, struct proto_file_t **files );

void ftp_seterror( const char *error );
void ftp_seterror_err( const char *error );

#endif /* FTP_H */
