/*  Server-Side Includes Wizard for screem.
 *  Copyright (C) 1999 Lee Mallabone
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gmodule.h>
#include <gnome.h>

#include "ssiWizard_handlers.h"
#include "ssiWizard.h"

#include "site.h"
#include "page.h"

extern GtkWidget *app;
extern Site *current_site;
extern Page *current_page;

/* Widgets that are accessed from ssiWizard_handlers.c */
GtkWidget *window1;
GtkWidget *var_print;
GtkWidget *var_name_label;
GtkWidget *var_name;
GtkWidget *var_value_label;
GtkWidget *var_value;
GtkWidget *cond_label;
GtkWidget *cond_expr;

GtkWidget *radiobutton6; /* if */
GtkWidget *radiobutton7; /* elif */
GtkWidget *radiobutton8; /* else */
GtkWidget *radiobutton9; /* endif */

GtkWidget *config_error;
GtkWidget *config_timefmt;
GtkWidget *config_sizemenu;
GtkWidget *config_sizemenu_menu;

/* file information */
GtkWidget *entry8;
GtkWidget *radiobutton3;
GtkWidget *radiobutton4;

GtkWidget *include_path;

GtkWidget *exec_command;

G_MODULE_EXPORT const gchar*
g_module_check_init( GModule *module )
{
           g_print("ssiWizard: check-init\n");
           return NULL;
}

G_MODULE_EXPORT void
g_module_unload( GModule *module )
{
           g_print( "ssiWizard: unloaded\n" );
}

G_MODULE_EXPORT void 
init() 
{
   GnomeUIInfo menuinfo[] = { 
	{
	   GNOME_APP_UI_ITEM, N_( "SSI directive..." ),
	   N_( "Insert a Server-side Include" ),
	   ssiWizard_create, NULL, NULL,
	   GNOME_APP_PIXMAP_STOCK,
	   GNOME_STOCK_MENU_BLANK,
	   0,
	   GDK_CONTROL_MASK, NULL
	},
      GNOMEUIINFO_END
   };
   
   
    gnome_app_insert_menus( GNOME_APP( app ),
			  _("_Insert/"), menuinfo);
   
   g_print( "ssiWizard: initialised\n" );
}

void
ssiWizard_create(void)
{

  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *frame5;
  GtkWidget *vbox4;
  GtkWidget *hbox13;
  GtkWidget *eventbox2;
  GtkWidget *label8;

  GtkWidget *hseparator5;
  GtkWidget *hbox11;
  GtkWidget *include_apply;
  GtkWidget *frame6;
  GtkWidget *vbox5;
  GtkWidget *hbox15;
  GSList *file_info_group = NULL;
  GtkWidget *hbox14;
  GtkWidget *eventbox3;
  GtkWidget *label9;

  GtkWidget *hseparator6;
  GtkWidget *hbox12;
  GtkWidget *info_apply;
  GtkWidget *frame4;
  GtkWidget *vbox3;
  GtkWidget *hbox8;
  GSList *variables_group = NULL;

  GtkWidget *var_set;
  GtkWidget *hbox9;
  GtkWidget *hbox10;
  GtkWidget *hseparator4;
  GtkWidget *hbox7;
  GtkWidget *var_apply;
  GtkWidget *frame1;
  GtkWidget *table2;

  GtkWidget *hbox1;

  GtkWidget *config_timehelp;
  GtkWidget *hseparator1;
  GtkWidget *hbox2;
  GtkWidget *config_apply;
  GtkWidget *alignment1;
  GtkWidget *glade_menuitem;
  GtkWidget *label3;
  GtkWidget *label1;
  GtkWidget *label11;
  GtkWidget *frame3;
  GtkWidget *vbox2;
  GtkWidget *hbox6;
  GtkWidget *label5;
  GtkWidget *exec_option;
  GtkWidget *exec_option_menu;

  GtkWidget *hseparator3;
  GtkWidget *hbox5;
  GtkWidget *exec_apply;
  GtkWidget *frame2;
  GtkWidget *vbox1;
  GtkWidget *hbox3;
  GtkWidget *label4;
  GtkWidget *echo_menu;
  GtkWidget *echo_menu_menu;
  GtkWidget *hseparator2;
  GtkWidget *hbox4;
  GtkWidget *echo_apply;
  GtkWidget *frame7;
  GtkWidget *vbox6;
  GtkWidget *hbox19;
  GSList *cond_group = NULL;
  GtkWidget *hbox20;
  GtkWidget *hseparator7;
  GtkWidget *hbox18;
  GtkWidget *cond_apply;
  GtkWidget *dialog_action_area1;
  GtkWidget *ssi_help;
  GtkWidget *close_ssi;
  GtkTooltips *tooltips;

  Page *page;

  if( current_site )
	  page = screem_site_get_current_page( current_site );
  else
	  page = current_page;

  g_return_if_fail( page != NULL );
   
   if (window1) {
      gdk_window_raise( window1->window );
      gdk_window_show( window1->window );
      return;
   }
   
   tooltips = gtk_tooltips_new ();

  window1 = gnome_dialog_new (_("Insert a 'Server-Side Include' directive."), NULL);
  gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
  gtk_window_set_policy (GTK_WINDOW (window1), FALSE, FALSE, FALSE);

  dialog_vbox1 = GNOME_DIALOG (window1)->vbox;
  gtk_object_set_data (GTK_OBJECT (window1), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  table1 = gtk_table_new (4, 2, FALSE);
  gtk_object_set_data (GTK_OBJECT (window1), "table1", table1);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);

  frame5 = gtk_frame_new (_("Include"));
  gtk_object_set_data (GTK_OBJECT (window1), "frame5", frame5);
  gtk_widget_show (frame5);
  gtk_table_attach (GTK_TABLE (table1), frame5, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame5), 3);

  vbox4 = gtk_vbox_new (FALSE, 3);
  gtk_object_set_data (GTK_OBJECT (window1), "vbox4", vbox4);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (frame5), vbox4);
  gtk_container_set_border_width (GTK_CONTAINER (vbox4), 3);

  hbox13 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox13", hbox13);
  gtk_widget_show (hbox13);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox13, TRUE, TRUE, 0);

  eventbox2 = gtk_event_box_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "eventbox2", eventbox2);
  gtk_widget_show (eventbox2);
  gtk_box_pack_start (GTK_BOX (hbox13), eventbox2, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, eventbox2, _("Should be a relative path. A leading slash denotes the root of your website only."), NULL);

  label8 = gtk_label_new (_("Filename: "));
  gtk_object_set_data (GTK_OBJECT (window1), "label8", label8);
  gtk_widget_show (label8);
  gtk_container_add (GTK_CONTAINER (eventbox2), label8);
  gtk_label_set_justify (GTK_LABEL (label8), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

  include_path = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "include_path", include_path);
  gtk_widget_show (include_path);
  gtk_box_pack_start (GTK_BOX (hbox13), include_path, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, include_path, _("Should be a relative path. A leading slash denotes the root of your website only."), NULL);

  hseparator5 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "hseparator5", hseparator5);
  gtk_widget_show (hseparator5);
  gtk_box_pack_start (GTK_BOX (vbox4), hseparator5, TRUE, TRUE, 0);

  hbox11 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox11", hbox11);
  gtk_widget_show (hbox11);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox11, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox11), 2);

  include_apply = gnome_stock_button (GNOME_STOCK_BUTTON_APPLY);
  gtk_object_set_data (GTK_OBJECT (window1), "include_apply", include_apply);
  gtk_widget_show (include_apply);
  gtk_box_pack_end (GTK_BOX (hbox11), include_apply, FALSE, FALSE, 0);

  frame6 = gtk_frame_new (_("File information"));
  gtk_object_set_data (GTK_OBJECT (window1), "frame6", frame6);
  gtk_widget_show (frame6);
  gtk_table_attach (GTK_TABLE (table1), frame6, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame6), 3);

  vbox5 = gtk_vbox_new (FALSE, 3);
  gtk_object_set_data (GTK_OBJECT (window1), "vbox5", vbox5);
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (frame6), vbox5);
  gtk_container_set_border_width (GTK_CONTAINER (vbox5), 3);

  hbox15 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox15", hbox15);
  gtk_widget_show (hbox15);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox15, TRUE, TRUE, 0);

  radiobutton3 = gtk_radio_button_new_with_label (file_info_group, _("Size"));
  file_info_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton3));
  gtk_object_set_data (GTK_OBJECT (window1), "radiobutton3", radiobutton3);
  gtk_widget_show (radiobutton3);
  gtk_box_pack_start (GTK_BOX (hbox15), radiobutton3, FALSE, FALSE, 0);

  radiobutton4 = gtk_radio_button_new_with_label (file_info_group, _("Modification time"));
  file_info_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton4));
  gtk_object_set_data (GTK_OBJECT (window1), "radiobutton4", radiobutton4);
  gtk_widget_show (radiobutton4);
  gtk_box_pack_start (GTK_BOX (hbox15), radiobutton4, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton4), TRUE);

  hbox14 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox14", hbox14);
  gtk_widget_show (hbox14);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox14, FALSE, FALSE, 0);

  eventbox3 = gtk_event_box_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "eventbox3", eventbox3);
  gtk_widget_show (eventbox3);
  gtk_box_pack_start (GTK_BOX (hbox14), eventbox3, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, eventbox3, _("Should be a relative path. A leading slash denotes the root of your website only."), NULL);

  label9 = gtk_label_new (_("Filename: "));
  gtk_object_set_data (GTK_OBJECT (window1), "label9", label9);
  gtk_widget_show (label9);
  gtk_container_add (GTK_CONTAINER (eventbox3), label9);
  gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);

  entry8 = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "entry8", entry8);
  gtk_widget_show (entry8);
  gtk_box_pack_start (GTK_BOX (hbox14), entry8, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltips, entry8, _("Should be a relative path. A leading slash denotes the root of your website only."), NULL);

  hseparator6 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "hseparator6", hseparator6);
  gtk_widget_show (hseparator6);
  gtk_box_pack_start (GTK_BOX (vbox5), hseparator6, TRUE, TRUE, 0);

  hbox12 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox12", hbox12);
  gtk_widget_show (hbox12);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox12, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox12), 2);

  info_apply = gnome_stock_button (GNOME_STOCK_BUTTON_APPLY);
  gtk_object_set_data (GTK_OBJECT (window1), "info_apply", info_apply);
  gtk_widget_show (info_apply);
  gtk_box_pack_end (GTK_BOX (hbox12), info_apply, FALSE, FALSE, 0);

  frame4 = gtk_frame_new (_("Variables"));
  gtk_object_set_data (GTK_OBJECT (window1), "frame4", frame4);
  gtk_widget_show (frame4);
  gtk_table_attach (GTK_TABLE (table1), frame4, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 3);

  vbox3 = gtk_vbox_new (FALSE, 3);
  gtk_object_set_data (GTK_OBJECT (window1), "vbox3", vbox3);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (frame4), vbox3);
  gtk_container_set_border_width (GTK_CONTAINER (vbox3), 3);

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox8", hbox8);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox8, TRUE, TRUE, 0);

  var_print = gtk_radio_button_new_with_label (variables_group, _("Print variables"));
  variables_group = gtk_radio_button_group (GTK_RADIO_BUTTON (var_print));
  gtk_object_set_data (GTK_OBJECT (window1), "var_print", var_print);
  gtk_widget_show (var_print);
  gtk_box_pack_start (GTK_BOX (hbox8), var_print, FALSE, FALSE, 0);

  var_set = gtk_radio_button_new_with_label (variables_group, _("Set a variable"));
  variables_group = gtk_radio_button_group (GTK_RADIO_BUTTON (var_set));
  gtk_object_set_data (GTK_OBJECT (window1), "var_set", var_set);
  gtk_widget_show (var_set);
  gtk_box_pack_start (GTK_BOX (hbox8), var_set, FALSE, FALSE, 0);

  hbox9 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox9", hbox9);
  gtk_widget_show (hbox9);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox9, TRUE, TRUE, 0);

  var_name_label = gtk_label_new (_("Variable name: "));
  gtk_object_set_data (GTK_OBJECT (window1), "var_name_label", var_name_label);
  gtk_widget_show (var_name_label);
  gtk_box_pack_start (GTK_BOX (hbox9), var_name_label, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (var_name_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (var_name_label), 7.45058e-09, 0.5);

  var_name = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "var_name", var_name);
  gtk_widget_show (var_name);
  gtk_box_pack_start (GTK_BOX (hbox9), var_name, TRUE, TRUE, 0);

  hbox10 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox10", hbox10);
  gtk_widget_show (hbox10);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox10, TRUE, TRUE, 0);

  var_value_label = gtk_label_new (_("Value: "));
  gtk_object_set_data (GTK_OBJECT (window1), "var_value_label", var_value_label);
  gtk_widget_show (var_value_label);
  gtk_box_pack_start (GTK_BOX (hbox10), var_value_label, TRUE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (var_value_label), 0, 0.5);

  var_value = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "var_value", var_value);
  gtk_widget_show (var_value);
  gtk_box_pack_start (GTK_BOX (hbox10), var_value, TRUE, TRUE, 0);

  hseparator4 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "hseparator4", hseparator4);
  gtk_widget_show (hseparator4);
  gtk_box_pack_start (GTK_BOX (vbox3), hseparator4, TRUE, TRUE, 0);

  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox7", hbox7);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox7, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox7), 2);

  var_apply = gnome_stock_button (GNOME_STOCK_BUTTON_APPLY);
  gtk_object_set_data (GTK_OBJECT (window1), "var_apply", var_apply);
  gtk_widget_show (var_apply);
  gtk_box_pack_end (GTK_BOX (hbox7), var_apply, FALSE, FALSE, 0);

  frame1 = gtk_frame_new (_("Configuration"));
  gtk_object_set_data (GTK_OBJECT (window1), "frame1", frame1);
  gtk_widget_show (frame1);
  gtk_table_attach (GTK_TABLE (table1), frame1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 3);

  table2 = gtk_table_new (5, 2, FALSE);
  gtk_object_set_data (GTK_OBJECT (window1), "table2", table2);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame1), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 3);

  config_error = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "config_error", config_error);
  gtk_widget_show (config_error);
  gtk_table_attach (GTK_TABLE (table2), config_error, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_table_attach (GTK_TABLE (table2), hbox1, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  config_timefmt = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "config_timefmt", config_timefmt);
  gtk_widget_show (config_timefmt);
  gtk_box_pack_start (GTK_BOX (hbox1), config_timefmt, TRUE, TRUE, 0);

  config_timehelp = gnome_href_new ("man:strftime(3)", _("help"));
  gtk_object_set_data (GTK_OBJECT (window1), "config_timehelp", config_timehelp);
  gtk_widget_show (config_timehelp);
  gtk_box_pack_start (GTK_BOX (hbox1), config_timehelp, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "hseparator1", hseparator1);
  gtk_widget_show (hseparator1);
  gtk_table_attach (GTK_TABLE (table2), hseparator1, 0, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox2", hbox2);
  gtk_widget_show (hbox2);
  gtk_table_attach (GTK_TABLE (table2), hbox2, 0, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox2), 2);

  config_apply = gnome_stock_button (GNOME_STOCK_BUTTON_APPLY);
  gtk_object_set_data (GTK_OBJECT (window1), "config_apply", config_apply);
  gtk_widget_show (config_apply);
  gtk_box_pack_end (GTK_BOX (hbox2), config_apply, FALSE, FALSE, 0);

  alignment1 = gtk_alignment_new (7.45058e-09, 0.5, 1, 1);
  gtk_object_set_data (GTK_OBJECT (window1), "alignment1", alignment1);
  gtk_widget_show (alignment1);
  gtk_table_attach (GTK_TABLE (table2), alignment1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  config_sizemenu = gtk_option_menu_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "config_sizemenu", config_sizemenu);
  gtk_widget_show (config_sizemenu);
  gtk_container_add (GTK_CONTAINER (alignment1), config_sizemenu);
  config_sizemenu_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("Bytes"));
   gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_size_menu), "bytes");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (config_sizemenu_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Kb or Mb"));
   gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_size_menu), "abbrev");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (config_sizemenu_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (config_sizemenu), config_sizemenu_menu);

  label3 = gtk_label_new (_("Time format: "));
  gtk_object_set_data (GTK_OBJECT (window1), "label3", label3);
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table2), label3, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label3), 7.45058e-09, 0.5);

  label1 = gtk_label_new (_("Error message: "));
  gtk_object_set_data (GTK_OBJECT (window1), "label1", label1);
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table2), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label1), 7.45058e-09, 0.5);

  label11 = gtk_label_new (_("Size format: "));
  gtk_object_set_data (GTK_OBJECT (window1), "label11", label11);
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (table2), label11, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label11), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label11), 0, 0.5);

  frame3 = gtk_frame_new (_("Execute"));
  gtk_object_set_data (GTK_OBJECT (window1), "frame3", frame3);
  gtk_widget_show (frame3);
  gtk_table_attach (GTK_TABLE (table1), frame3, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 3);

  vbox2 = gtk_vbox_new (FALSE, 3);
  gtk_object_set_data (GTK_OBJECT (window1), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame3), vbox2);
  gtk_container_set_border_width (GTK_CONTAINER (vbox2), 3);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox6", hbox6);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox6, TRUE, TRUE, 0);

  label5 = gtk_label_new (_("Exec: "));
  gtk_object_set_data (GTK_OBJECT (window1), "label5", label5);
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (hbox6), label5, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label5), 7.45058e-09, 0.5);

  exec_option = gtk_option_menu_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "exec_option", exec_option);
  gtk_widget_show (exec_option);
  gtk_box_pack_start (GTK_BOX (hbox6), exec_option, FALSE, FALSE, 0);
  exec_option_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("CGI"));
   gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_exec_menu), "cgi");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (exec_option_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Shell"));
   gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_exec_menu), "cmd");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (exec_option_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (exec_option), exec_option_menu);

  exec_command = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "exec_command", exec_command);
  gtk_widget_show (exec_command);
  gtk_box_pack_start (GTK_BOX (hbox6), exec_command, TRUE, TRUE, 0);

  hseparator3 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "hseparator3", hseparator3);
  gtk_widget_show (hseparator3);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator3, TRUE, TRUE, 0);

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox5", hbox5);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox5, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox5), 2);

  exec_apply = gnome_stock_button (GNOME_STOCK_BUTTON_APPLY);
  gtk_object_set_data (GTK_OBJECT (window1), "exec_apply", exec_apply);
  gtk_widget_show (exec_apply);
  gtk_box_pack_end (GTK_BOX (hbox5), exec_apply, FALSE, FALSE, 0);

  frame2 = gtk_frame_new (_("Echo"));
  gtk_object_set_data (GTK_OBJECT (window1), "frame2", frame2);
  gtk_widget_show (frame2);
  gtk_table_attach (GTK_TABLE (table1), frame2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 3);

  vbox1 = gtk_vbox_new (FALSE, 3);
  gtk_object_set_data (GTK_OBJECT (window1), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (frame2), vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 3);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox3", hbox3);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, TRUE, TRUE, 0);

  label4 = gtk_label_new (_("Variable: "));
  gtk_object_set_data (GTK_OBJECT (window1), "label4", label4);
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (hbox3), label4, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);

  echo_menu = gtk_option_menu_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "echo_menu", echo_menu);
  gtk_widget_show (echo_menu);
  gtk_box_pack_start (GTK_BOX (hbox3), echo_menu, TRUE, TRUE, 0);
  echo_menu_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("Date (GMT)"));
   gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_var_menu), "DATE_GMT");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (echo_menu_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Date (Local)"));
   gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_var_menu), "DATE_LOCAL");
   gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (echo_menu_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Document Name"));
      gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_var_menu), "DOCUMENT_NAME");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (echo_menu_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Document URI"));
      gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_var_menu), "DOCUMENT_URI");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (echo_menu_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Last Modified"));
      gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		       GTK_SIGNAL_FUNC (handle_var_menu), "LAST_MODIFIED");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (echo_menu_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (echo_menu), echo_menu_menu);

  hseparator2 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "hseparator2", hseparator2);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator2, TRUE, TRUE, 0);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox4", hbox4);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox4, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox4), 2);

  echo_apply = gnome_stock_button (GNOME_STOCK_BUTTON_APPLY);
  gtk_object_set_data (GTK_OBJECT (window1), "echo_apply", echo_apply);
  gtk_widget_show (echo_apply);
  gtk_box_pack_end (GTK_BOX (hbox4), echo_apply, FALSE, FALSE, 0);

  frame7 = gtk_frame_new (_("Conditionals"));
  gtk_object_set_data (GTK_OBJECT (window1), "frame7", frame7);
  gtk_widget_show (frame7);
  gtk_table_attach (GTK_TABLE (table1), frame7, 0, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame7), 3);

  vbox6 = gtk_vbox_new (FALSE, 3);
  gtk_object_set_data (GTK_OBJECT (window1), "vbox6", vbox6);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (frame7), vbox6);
  gtk_container_set_border_width (GTK_CONTAINER (vbox6), 3);

  hbox19 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox19", hbox19);
  gtk_widget_show (hbox19);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox19, TRUE, TRUE, 0);

  radiobutton6 = gtk_radio_button_new_with_label (cond_group, _("If"));
  cond_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton6));
  gtk_object_set_data (GTK_OBJECT (window1), "radiobutton6", radiobutton6);
  gtk_widget_show (radiobutton6);
  gtk_box_pack_start (GTK_BOX (hbox19), radiobutton6, FALSE, FALSE, 0);

  radiobutton7 = gtk_radio_button_new_with_label (cond_group, _("Elif"));
  cond_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton7));
  gtk_object_set_data (GTK_OBJECT (window1), "radiobutton7", radiobutton7);
  gtk_widget_show (radiobutton7);
  gtk_box_pack_start (GTK_BOX (hbox19), radiobutton7, FALSE, FALSE, 0);

  radiobutton8 = gtk_radio_button_new_with_label (cond_group, _("Else"));
  cond_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton8));
  gtk_object_set_data (GTK_OBJECT (window1), "radiobutton8", radiobutton8);
  gtk_widget_show (radiobutton8);
  gtk_box_pack_start (GTK_BOX (hbox19), radiobutton8, FALSE, FALSE, 0);

  radiobutton9 = gtk_radio_button_new_with_label (cond_group, _("Endif"));
  cond_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton9));
  gtk_object_set_data (GTK_OBJECT (window1), "radiobutton9", radiobutton9);
  gtk_widget_show (radiobutton9);
  gtk_box_pack_start (GTK_BOX (hbox19), radiobutton9, FALSE, FALSE, 0);

  hbox20 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox20", hbox20);
  gtk_widget_show (hbox20);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox20, TRUE, TRUE, 0);

  cond_label = gtk_label_new (_("Test expression: "));
  gtk_object_set_data (GTK_OBJECT (window1), "cond_label", cond_label);
  gtk_widget_show (cond_label);
  gtk_box_pack_start (GTK_BOX (hbox20), cond_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (cond_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (cond_label), 0, 0.5);

  cond_expr = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "cond_expr", cond_expr);
  gtk_widget_show (cond_expr);
  gtk_box_pack_start (GTK_BOX (hbox20), cond_expr, TRUE, TRUE, 0);

  hseparator7 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (window1), "hseparator7", hseparator7);
  gtk_widget_show (hseparator7);
  gtk_box_pack_start (GTK_BOX (vbox6), hseparator7, TRUE, TRUE, 0);

  hbox18 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window1), "hbox18", hbox18);
  gtk_widget_show (hbox18);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox18, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox18), 2);

  cond_apply = gnome_stock_button (GNOME_STOCK_BUTTON_APPLY);
  gtk_object_set_data (GTK_OBJECT (window1), "cond_apply", cond_apply);
  gtk_widget_show (cond_apply);
  gtk_box_pack_end (GTK_BOX (hbox18), cond_apply, FALSE, FALSE, 0);

  dialog_action_area1 = GNOME_DIALOG (window1)->action_area;
  gtk_object_set_data (GTK_OBJECT (window1), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_EDGE);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

  ssi_help = gnome_stock_button (GNOME_STOCK_BUTTON_HELP);
  gtk_object_set_data (GTK_OBJECT (window1), "ssi_help", ssi_help);
  gtk_widget_show (ssi_help);
  gtk_container_add (GTK_CONTAINER (dialog_action_area1), ssi_help);
  GTK_WIDGET_SET_FLAGS (ssi_help, GTK_CAN_DEFAULT);

  close_ssi = gnome_stock_button (GNOME_STOCK_BUTTON_CLOSE);
  gtk_object_set_data (GTK_OBJECT (window1), "close_ssi", close_ssi);
  gtk_widget_show (close_ssi);
  gtk_container_add (GTK_CONTAINER (dialog_action_area1), close_ssi);
  GTK_WIDGET_SET_FLAGS (close_ssi, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (include_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_include_apply_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (info_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_info_apply_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (var_print), "clicked",
                      GTK_SIGNAL_FUNC (disable_var_widgets),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (var_set), "clicked",
                      GTK_SIGNAL_FUNC (enable_var_widgets),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (var_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_var_apply_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (config_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_config_apply_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (exec_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_exec_apply_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (echo_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_echo_apply_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton6), "clicked",
                      GTK_SIGNAL_FUNC (enable_test_expr),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton7), "clicked",
                      GTK_SIGNAL_FUNC (enable_test_expr),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton8), "clicked",
                      GTK_SIGNAL_FUNC (disable_test_expr),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton9), "clicked",
                      GTK_SIGNAL_FUNC (disable_test_expr),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (cond_apply), "clicked",
                      GTK_SIGNAL_FUNC (on_cond_apply_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (ssi_help), "clicked",
                      GTK_SIGNAL_FUNC (on_ssi_help_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (close_ssi), "clicked",
                      GTK_SIGNAL_FUNC (on_close_ssi_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (window1), "delete_event",
                      GTK_SIGNAL_FUNC (on_close_ssi_clicked),
                      NULL);
   
   gtk_object_set_data (GTK_OBJECT (window1), "tooltips", tooltips);
  disable_var_widgets();
  gtk_widget_show (window1);
}

