/*  Screem:  entityWizard.c,
 *  A wizard for entering special characters
 *
 *  Copyright (C) 1999  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gmodule.h>
#include <gnome.h>

#include "html.h"   /* contains all the entities */
#include "site.h"
#include "page.h"
#include "editor.h"

extern GtkWidget *app;
extern Site *current_site;
extern Page *current_page;

static GtkWidget* create_dialog( void );
void entityWizard( void );
static void selected( GtkCList *clist, gint row, gint column,
		      GdkEventButton *event, gpointer data );
static void clicked( GtkWidget *widget, gint button, GtkWidget **dialog );

/*********************************************************************/
G_MODULE_EXPORT const gchar* 
g_module_check_init( GModule *module )
{
        g_print("entityWizard: check-init\n");
        return NULL;
}
/*********************************************************************/
G_MODULE_EXPORT void
g_module_unload( GModule *module )
{
        g_print( "entityWizard: unloaded\n" );
}
/*********************************************************************/

G_MODULE_EXPORT void 
init() 
{
	GnomeUIInfo menuinfo[] = { 
                {
                        GNOME_APP_UI_ITEM, N_( "Entity..." ),
                        N_( "Insert a special character entity" ),
                        entityWizard, NULL, NULL,
                        GNOME_APP_PIXMAP_STOCK,
                        GNOME_STOCK_MENU_BLANK,
                        0,
                        GDK_CONTROL_MASK, NULL
                },
                GNOMEUIINFO_END
        };

	/* place menu item after image under insert */
        gnome_app_insert_menus( GNOME_APP( app ),
                                _("_Insert/"), menuinfo);

	g_print( "entityWizard: initialised\n" );
}
/*********************************************************************/
void entityWizard()
{
	static GtkWidget *dialog = NULL;
	Page *page;
 
	if( current_site )
		page = screem_site_get_current_page( current_site );
         else
                page = current_page;

        g_return_if_fail( page != NULL );

	if( dialog ) {
                gdk_window_raise( dialog->window );
                gdk_window_show( dialog->window );
                return;
        }

        dialog = create_dialog();

	gtk_signal_connect( GTK_OBJECT( dialog ), "clicked",
			    GTK_SIGNAL_FUNC( clicked ), &dialog );
	gtk_signal_connect( GTK_OBJECT( dialog ), "delete_event",
			    GTK_SIGNAL_FUNC( clicked ), &dialog );

        gtk_widget_show_all( dialog );
}
/*********************************************************************/
static GtkWidget* create_dialog()
{
	GtkWidget *dialog;
	GtkWidget *notebook;
	GtkWidget *label;

	gchar *titles[] = {
		_("Name"),
		_("Entity"),
		NULL
	};
	gchar *items[ 2 ];

	GtkWidget *sw;
	GtkWidget *list;
	gint num;

	dialog = gnome_dialog_new( _( "Entity Wizard" ),
				   GNOME_STOCK_BUTTON_CLOSE, NULL );

	notebook = gtk_notebook_new();
	gtk_box_pack_start( GTK_BOX( GNOME_DIALOG( dialog )->vbox ),
			    notebook, TRUE, TRUE, GNOME_PAD );

	/* ISO-8859-1 */
	sw = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( sw ),
                                        GTK_POLICY_AUTOMATIC,
                                        GTK_POLICY_AUTOMATIC );
	gtk_widget_set_usize( sw, -1, 200 );
	list = gtk_clist_new_with_titles( 2, titles );
	gtk_clist_set_column_auto_resize( GTK_CLIST( list ), 0, TRUE );
        gtk_clist_set_selection_mode( GTK_CLIST( list ),GTK_SELECTION_BROWSE );
	/* insert the entities */
	for( num = 0; ISO_8859_1[ num ]; num ++ ) {
		items[ 0 ] = ISO_8859_1[ num ];
		items[ 1 ] = ISO_8859_1[ num ];
		gtk_clist_append( GTK_CLIST( list ), items );
	}
	gtk_container_add( GTK_CONTAINER( sw ), list );

	label = gtk_label_new( _( "ISO-8859-1" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ),
				  sw, label );
	gtk_signal_connect( GTK_OBJECT( list ), "select-row",
                            GTK_SIGNAL_FUNC( selected ), 0 );

	/* Math/Greek/Symbolic */
	sw = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( sw ),
                                        GTK_POLICY_AUTOMATIC,
                                        GTK_POLICY_AUTOMATIC );
	gtk_widget_set_usize( sw, -1, 200 );
	list = gtk_clist_new_with_titles( 2, titles );
	gtk_clist_set_column_auto_resize( GTK_CLIST( list ), 0, TRUE );
        gtk_clist_set_selection_mode( GTK_CLIST( list ),GTK_SELECTION_BROWSE );
	/* insert the entities */
	for( num = 0; MATH_GREEK_SYMBOLIC[ num ]; num ++ ) {
		items[ 0 ] = MATH_GREEK_SYMBOLIC[ num ];
		items[ 1 ] = MATH_GREEK_SYMBOLIC[ num ];
		gtk_clist_append( GTK_CLIST( list ), items );
	}
	gtk_container_add( GTK_CONTAINER( sw ), list );

	label = gtk_label_new( _( "Math/Greek/Symbolic" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ),
				  sw, label );
	gtk_signal_connect( GTK_OBJECT( list ), "select-row",
                            GTK_SIGNAL_FUNC( selected ), 0 );

	/* Markup/Internationalisation */
	sw = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( sw ),
                                        GTK_POLICY_AUTOMATIC,
                                        GTK_POLICY_AUTOMATIC );
	gtk_widget_set_usize( sw, -1, 200 );
	list = gtk_clist_new_with_titles( 2, titles );
	gtk_clist_set_column_auto_resize( GTK_CLIST( list ), 0, TRUE );
        gtk_clist_set_selection_mode( GTK_CLIST( list ),GTK_SELECTION_BROWSE );
	/* insert the entities */
	for( num = 0; MARKUP_INTL[ num ]; num ++ ) {
		items[ 0 ] = MARKUP_INTL[ num ];
		items[ 1 ] = MARKUP_INTL[ num ];
		gtk_clist_append( GTK_CLIST( list ), items );
	}
	gtk_container_add( GTK_CONTAINER( sw ), list );

	label = gtk_label_new( _( "Markup/Internationalisation" ) );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ),
				  sw, label );
	gtk_signal_connect( GTK_OBJECT( list ), "select-row",
                            GTK_SIGNAL_FUNC( selected ), 0 );

	return dialog;
}
/***********************************************************************/
static void selected( GtkCList *clist, gint row, gint column,
		      GdkEventButton *event, gpointer data )
{
	static guint32 t = 0;
	gint pos;
	gchar *text;
	gchar *info[ 1 ];

	if( t != event->time ) {
		t = event->time;
		return;
	}

	/* was double clicked */
	gtk_clist_get_text( clist, row, 1, &info[ 0 ] );

	/* insert info[ 0 ] */
	pos = screem_editor_get_pos();
	text = g_strdup_printf( "&%s;", info[ 0 ] );
	screem_editor_insert( pos, text );
	screem_editor_set_pos( pos + strlen( text ) );
	g_free( text );
}
/**************************************************************************/
static void clicked( GtkWidget *widget, gint button, GtkWidget **dialog )
{
	gtk_widget_destroy( widget );
	*dialog = NULL;
}
