#ifndef SITETREEUI_H
#define SITETREEUI_H

void refresh_file_tree( void );

void tree_clicked( GtkWidget *widget, GdkEventButton *event,
		   gpointer data );

void tree_set_dnd_data( GtkWidget *widget, GdkDragContext *context,
			GtkSelectionData *selectionData, guint info,
			guint time, gpointer data );
void tree_drag_begin( GtkWidget *widget, GdkDragContext *context,
		      gpointer data );
gboolean tree_drag_motion( GtkWidget *widget, 
			   GdkDragContext *context, 
			   gint x, gint y, guint time,
			   gpointer data );
void tree_drop_data( GtkWidget *widget, GdkDragContext *context,
		     gint x, gint y, GtkSelectionData *selectionData,
		     guint info, guint time );

typedef enum _SiteTreeEnums {
	TARGET_URI_LIST
} SiteTreeEnums;

static const GtkTargetEntry site_tree_drag_types[] = {
        { "text/uri-list", 0, TARGET_URI_LIST },
};
static const gint site_tree_num_drag_types = sizeof( site_tree_drag_types) / \
sizeof( site_tree_drag_types [0] );

static const GtkTargetEntry site_tree_drop_types[] = {
        { "text/uri-list", 0, TARGET_URI_LIST },
};
static const gint site_tree_num_drop_types = sizeof( site_tree_drop_types) / \
sizeof( site_tree_drop_types [0] );


void screem_browse_list_show_dir( gchar *dir );
void browse_list_clicked( GtkWidget *widget, GdkEventButton *event,
			  gpointer data );

void resource_list_display( void );

#endif
