#ifndef MENUS_H
#define MENUS_H

#include <gnome.h>

#include "cvs.h"
#include "editMenu.h"
#include "interface.h"
#include "page.h"
#include "pageUI.h"
#include "preferences.h"
#include "site.h"
#include "siteUI.h"
#include "siteTemplate.h"


static GnomeUIInfo new_menu_item[] = {
        GNOMEUIINFO_MENU_NEW_ITEM( N_("_New Site..."), N_("Create a new site"),
                                   GTK_SIGNAL_FUNC( screem_site_create_site ),
				   NULL ),
        GNOMEUIINFO_MENU_NEW_ITEM( N_("_New Page..."), 
                                   N_("Create a new page (add if working on a site)"), 
                                   GTK_SIGNAL_FUNC( screem_page_create_page ),
				   NULL ),
	GNOMEUIINFO_MENU_NEW_ITEM( N_( "_New Blank Page" ),
				   N_("Create a blank page (add if working on a site)" ),
				   GTK_SIGNAL_FUNC( screem_page_create_blank_page ),
				   NULL ),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_NEW_ITEM( N_( "_New Site Template" ),
				   N_( "Create a new site template" ),
				   GTK_SIGNAL_FUNC( site_template_window ),
				   NULL ),
	GNOMEUIINFO_END
};

static GnomeUIInfo recent_sites_menu[] = {
	GNOMEUIINFO_END
};

static GnomeUIInfo recent_pages_menu[] = {
	GNOMEUIINFO_END
};

static GnomeUIInfo file_menu[] = {
        GNOMEUIINFO_MENU_NEW_SUBTREE( new_menu_item ),
        GNOMEUIINFO_SEPARATOR,
        { GNOME_APP_UI_ITEM, N_("_Open Site..."), N_( "Open a site" ),
          GTK_SIGNAL_FUNC( screem_site_open ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 'O',
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Save Site"), N_( "Save a site" ),
	  GTK_SIGNAL_FUNC( screem_site_save_proxy ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 'S',
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Save Site as..."), N_( "Save site as" ),
          GTK_SIGNAL_FUNC( screem_site_save_as ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS, 0,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Close Site"), N_( "Close the current site" ),
          GTK_SIGNAL_FUNC( screem_site_close_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0,
          GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SUBTREE( N_("_Recent Sites"), recent_sites_menu ),
        GNOMEUIINFO_SEPARATOR,
        { GNOME_APP_UI_ITEM, N_("_Open Page..."), N_( "Open a single page" ),
          GTK_SIGNAL_FUNC( screem_page_open ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Save Page"), N_( "Save the current page" ),
          GTK_SIGNAL_FUNC( screem_page_save_proxy ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 0,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Save Page as..."), 
          N_( "Save the current page as" ),
          GTK_SIGNAL_FUNC( screem_page_save_as ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS, 0,
          GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Close Page"), N_( "Close the current page" ),
          GTK_SIGNAL_FUNC( screem_page_close_page ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0,
          GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SUBTREE( N_("_Recent Pages"), recent_pages_menu  ),
        GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_PRINT_ITEM( 0, 0 ),
        GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_EXIT_ITEM( gtk_main_quit, 0 ),
        GNOMEUIINFO_END
};

static GnomeUIInfo edit_menu[] = {
        GNOMEUIINFO_MENU_UNDO_ITEM( 0, 0 ),
        GNOMEUIINFO_MENU_REDO_ITEM( 0, 0 ),
        GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_CUT_ITEM( GTK_SIGNAL_FUNC( cut ), 0 ),
        GNOMEUIINFO_MENU_COPY_ITEM( GTK_SIGNAL_FUNC( copy ), 0 ),
        GNOMEUIINFO_MENU_PASTE_ITEM( GTK_SIGNAL_FUNC( paste ), 0 ),
        GNOMEUIINFO_MENU_CLEAR_ITEM( GTK_SIGNAL_FUNC( clear ), 0 ),
        GNOMEUIINFO_MENU_SELECT_ALL_ITEM( GTK_SIGNAL_FUNC( select_all ), 0 ),
        GNOMEUIINFO_SEPARATOR,
        GNOMEUIINFO_MENU_FIND_ITEM( GTK_SIGNAL_FUNC( find ), 0 ),
        GNOMEUIINFO_MENU_FIND_AGAIN_ITEM( GTK_SIGNAL_FUNC( find_again ), 0 ),
        GNOMEUIINFO_MENU_REPLACE_ITEM( GTK_SIGNAL_FUNC( replace ), 0 ),
	GNOMEUIINFO_SEPARATOR,
	{
		GNOME_APP_UI_ITEM, N_( "Goto Line..." ), 
		N_( "Move the cursor to the specified line" ),
		GTK_SIGNAL_FUNC( 0 ), NULL, NULL, GNOME_APP_PIXMAP_STOCK,
		GNOME_STOCK_MENU_BLANK, 0, GDK_CONTROL_MASK, NULL
	},
	GNOMEUIINFO_END
};

static GnomeUIInfo view_menu[] = {
        GNOMEUIINFO_END
};

static GnomeUIInfo insert_menu[] = {
        GNOMEUIINFO_END
};

static GnomeUIInfo cvs_menu[] = {
        { GNOME_APP_UI_ITEM, N_("_Checkout site"), 
          N_( "Obtain site from cvs" ),
          GTK_SIGNAL_FUNC( cvs_checkout_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        { GNOME_APP_UI_ITEM, N_("_Update site"), 
          N_( "Update local copy of site" ),
          GTK_SIGNAL_FUNC( cvs_update_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        { GNOME_APP_UI_ITEM, N_("_Update page"), 
          N_( "Update local copy of page from CVS" ),
          GTK_SIGNAL_FUNC( cvs_update_page ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        GNOMEUIINFO_SEPARATOR,
        { GNOME_APP_UI_ITEM, N_("_Import site..."), 
          N_( "Add the site to the cvs repository" ),
          GTK_SIGNAL_FUNC( cvs_import_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        { GNOME_APP_UI_ITEM, N_("_Commit site..."), 
          N_( "Commit all changes made to site" ),
	  GTK_SIGNAL_FUNC( cvs_commit_site ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        { GNOME_APP_UI_ITEM, N_("_Commit page..."), 
          N_( "Commit the current page" ),
          GTK_SIGNAL_FUNC( cvs_commit_page ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
        GNOMEUIINFO_END
};

static GnomeUIInfo tools_menu[] = {
	{ GNOME_APP_UI_ITEM, N_( "Site Template Editor" ),
	  N_( "Edit a Site Template" ),
          GTK_SIGNAL_FUNC( site_template_window ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK, 0,
          GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo settings_menu[] = {
        { GNOME_APP_UI_ITEM, N_("_Site..."), 
          N_( "Alter site settings" ),
          GTK_SIGNAL_FUNC( screem_site_settings_dialog ), NULL, NULL,
          GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF, 0,
          GDK_CONTROL_MASK, NULL },
        GNOMEUIINFO_MENU_PREFERENCES_ITEM( GTK_SIGNAL_FUNC( edit_preferences ),
					   0 ),
        GNOMEUIINFO_END
};

static GnomeUIInfo help_menu[] = {
        GNOMEUIINFO_MENU_ABOUT_ITEM( GTK_SIGNAL_FUNC( create_about ), 0 ),
        GNOMEUIINFO_END
};

static GnomeUIInfo pages_menu[] = {
	GNOMEUIINFO_END
};

static GnomeUIInfo main_menu[] = {
        GNOMEUIINFO_MENU_FILE_TREE( file_menu ),
        GNOMEUIINFO_MENU_EDIT_TREE( edit_menu ),
        GNOMEUIINFO_SUBTREE( N_("_Insert"), insert_menu ),
	GNOMEUIINFO_SUBTREE( N_("_CVS"), cvs_menu ),
	GNOMEUIINFO_SUBTREE( N_("_Tools" ), tools_menu ),
	GNOMEUIINFO_MENU_SETTINGS_TREE( settings_menu ),
        GNOMEUIINFO_MENU_HELP_TREE( help_menu ),
        GNOMEUIINFO_END
};


#endif
