#!/usr/bin/env python

##  Copyright (C) 1998,1999  marduk <marduk@python.net>

##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.

##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.

##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: linbot.py,v 1.4 1999/02/21 16:39:25 marduk Exp $

# $Log: linbot.py,v $
# Revision 1.4  1999/02/21 16:39:25  marduk
# 1.0b8
#
# Revision 1.3  1999/01/10 01:01:44  marduk
# Linbot 1.0b6
#
# Revision 1.2  1998/12/23 07:34:59  marduk
# Fixed problem in linbot.py "import parser"
#
# Revision 1.1.1.2  1998/12/20 23:27:50  marduk
# This is pre 1.0, I hope
#

__version__='1.0'
__author__ = 'marduk (marduk@python.net)'

USAGE='linbot [-abv][-l url][-x url]... [-y url]... [-o dir][-w sec] url [location]...'
PYTHON_VERSION=1.5 # not used right now
explored = []
problem_db = {}
linkList = {}

import sys
import time
from plugins.rptlib import *

start_time = time.ctime(time.time())

# importing the config.py file is a real problem if the user did not install
# the files EXACTLY the way I said to... or even using the frozen version is
# becoming a real bitch.  I will just have to tell them right out how to fix it.
try:
    sys.path = ['.'] + sys.path
    import config
except ImportError:
    sys.stdout.write('Please verify that PYTHONPATH knows where to find "config.py"\n')
    sys.exit(1)

import myUrlLib
Link=myUrlLib.Link

# myUrlLib will be looking for a 'config' module.  set it up here.
myUrlLib.config=config

def parse_args():
    import getopt
    global URL
    try:
	optlist, args = getopt.getopt(sys.argv[1:],'vl:x:y:ao:bw:')
    except getopt.error, reason:
	print reason
	print USAGE
	sys.exit(1)
    for flag,arg in optlist:
	if flag=='-v':
	    print_version()
	    sys.exit(0)
	elif flag=='-x':
	    config.EXCLUDED_URLS.append(arg)
	elif flag=='-y':
	    config.YANKED_URLS.append(arg)
	elif flag=='-a':
	    config.AVOID_EXTERNAL_LINKS=1
	elif flag=='-o':
	    config.OUTPUT_DIR=arg
	elif flag=='-b':
	    config.BASE_URLS_ONLY=1
	elif flag=='-w':
	    config.WAIT_BETWEEN_REQUESTS=int(arg)
	elif flag=='-l':
	    config.LOGO_HREF=arg

    if len(args)==0:
	print USAGE
	sys.exit(1)
    else: URL = args[0]
    config.HOSTS=args[1:]

def print_version():
    """Print version information"""
    import os
    print "    Linbot: " + __version__
    print "    Python: " + sys.version
    print "    OS:     " + os.name
    print

def warn():
    """Warn the user that something has gone wrong."""
    print "*******************************************"
    print "*                                         *"
    print "* Warning, Linbot has found nothing to    *"
    print "* report for this site.  If you feel this *"
    print "* is in error, please contact             *"
    print "* %s.                                     *" % __author__
    print "* and specify the environment that caused *"
    print "* this to occur.                          *"
    print "*                                         *"
    print "* Linbot %s                               *" % __version__
    print "*                                         *"
    print "*******************************************"

# set up the pages
plugins = config.PLUGINS

if __name__ == '__main__':

    parse_args()
    config.OUTPUT_DIR=config.OUTPUT_DIR + '/'

    print 'checking site....'
    try:
	Link.base = Link(URL,None) # this will take a while
    except KeyboardInterrupt:
	sys.stderr.write("Interrupted\n")
	sys.exit(1)
    print 'done.'
    if not hasattr(Link.base,"URL"):
	warn()
	sys.exit(1)

    linkList = Link.linkList

    # now we can write out the files
    # start with the frame-description page
    print 'Generating reports...'
    main_index()
    nav_bar(plugins)
    print 'done.'

