<?php
/*
 * $Horde: horde/test.php3,v 1.1.2.21 2001/03/14 14:58:56 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

// stub to avoid errors
class ImpSession {
}

/* We want to be as verbose as possible here. */
error_reporting(E_ALL);

function status($foo) {
    if ($foo) {
        echo '<font color="green"><b>Yes</b></font>';
    } else {
        echo '<font color="red"><b>No</b></font>';
    }
}

/* Horde versions */
$versions = array();
require './lib/version.php';
$versions['horde'] = HORDE_VERSION;

if (@is_readable("./imp/lib/version.php")) {
    include "./imp/lib/version.php";
    $versions['imp'] = IMP_VERSION;
}

/* PHP Version */
$version = phpversion();
$major = $version[0];
$pl = strstr($version, "pl");
if ($pl) {
    $version = substr_replace($version, '', -strlen($pl));
}
if ($major == 3) {
    $bits = explode('.', $version);
    $minor = $bits[count($bits) - 1];
    $class = 'release';
} else {
    $register_globals = ini_get('register_globals');
    if (strspn($version, '0123456789.') == strlen($version)) {
        $bits = explode('.', $version);
        $minor = $bits[count($bits) - 1];
        $class = 'release';
    } else {
        $tail = substr($version, -4);
        if (($tail == '-dev') || ($tail == '-cvs')) {
            $bits = explode('.', $version);
            $minor = $bits[count($bits) - 1];
            $minor = substr($minor, 0, strlen($minor) - 4);
            $class = substr($tail, 1);
        } else {
            $minor = substr($version, 3);
            $class = 'beta';
        }
    }
}

/* PHP module capabilities */
$imap = function_exists('imap_open');
$ldap = function_exists('ldap_bind');
$mysql = function_exists('mysql_pconnect');
$pgsql = function_exists('pg_connect');

/* PHPLIB tests */
$phplib = function_exists('page_open');
$track_vars = isset($HTTP_GET_VARS);

/* PHP Settings */
$magic_quotes_gpc = !get_magic_quotes_gpc();
$magic_quotes_runtime = !get_magic_quotes_runtime();


/* Handle special modes */
if (isset($mode)) {
    switch ($mode) {

    case 'phpinfo':
        phpinfo();
        exit;
        break;

    case 'phplib-horde':
        page_open(array('sess' => 'HordeSession'));

        // s is a per session variable, u is a per user variable.
        if (!isset($s)) {
            $s = 0;
            $sess->register('s');
        }
        ?>
        <html><body bgcolor="white" text="black">
            <a href="<?php $sess->pself_url()?>">Reload</a> this page to see the counters increment.<br>
            <a href="test.php3">Go back</a> to the test.php3 page.<br>
            <a href="test.php3?mode=phpinfo">View</a> the output of phpinfo().<br>
            <h3>Per Session Data: <?php echo ++$s ?></h3>
            Session ID: <?php echo $sess->id ?>
            <p>If this page works correctly, then you have a correctly configured HordeSession class. You should be done with PHPLIB setup.
        </body></html>
        <?php
        // Save data back to database.
        page_close();
        break;

    default:
        break;
    }
} else {

?>

<html>
<head>
<title>Horde: System Capabilities Test</title>
</head>

<body bgcolor="white" text="black">

<font face="Helvetica, Arial, sans-serif" size="2">
<a href="test.php3?mode=phpinfo">View phpinfo() screen</a>

<h3>Horde Versions</h3>
<ul>
<?php
while (list($module, $ver) = each($versions)) {
    $module = ucfirst($module);
    if ($module == 'Imp')
        $module = 'IMP';
    echo "<li>$module: $ver</li>\n";
}
?>
</ul>

<h3>PHP Version</h3>
<ul>
    <li>PHP Version: <?php echo "$version$pl"; ?></li>
    <li>PHP Major Version: <?php echo $major; ?></li>
    <li>PHP Minor Version: <?php echo "$minor$pl"; ?></li>
    <li>PHP Version Classification: <?php echo $class; ?></li>
    <?php if ($major == 3) {
        if ($minor < 16): ?>
            <li><font color="red">Your PHP3 version is older than 3.0.16. You should upgrade to 3.0.16 (or later) and apply the patch(es) described in horde/docs/INSTALL.</font></li>
        <?php else: ?>
            <li><font color="green">Your PHP3 version is recent. You should not have any problems with Horde modules, provided that you have applied the patch(es) described in horde/docs/INSTALL.</font></li>
        <?php endif;
    } elseif ($major == 4) {
        if ($class == 'beta') { ?>
            <li><font color="red">You are running a beta or release candidate of PHP4. You need to upgrade to a release version, at least 4.0.3.</font></li>
        <?php } elseif ($minor < 3) { ?>
            <li><font color="red">You are running a version of PHP4 older than 4.0.3. You need to upgrade to at least 4.0.3.</font></li>
        <?php } else { ?>
            <li><font color="green">You are running a supported release of PHP4. Enjoy the ride!</font></li>
        <?php } ?>
    <?php } else { ?>
        <li><font color="orange">Wow, a mystical PHP from the future. Let <a href="mailto:dev@lists.horde.org">dev@lists.horde.org</a> know what version you have so we can fix this script.</font></li>
    <?php } ?>
</ul>

<h3>PHP Module Capabilities</h3>
<ul>
    <li>IMAP Support: <?php status($imap) ?></li>
    <?php if (!$imap) { ?><li><font color="red">Without IMAP support, <a href="http://horde.org/imp/">IMP</a> will not run. You will need to fix this if you want to run IMP.</font></li><?php } ?>
    <li>LDAP Support: <?php status($ldap) ?></li>
    <li>MySQL Support: <?php status($mysql) ?></li>
    <li>PostgreSQL Support: <?php status($pgsql) ?></li>
</ul>

<h3>PHPLIB Configuration</h3>
<ul>
    <li>track_vars: <?php echo status($track_vars) ?></li>
    <?php if (!$track_vars) { ?>
        <li><font color="red">PHPLIB will not work correctly with track_vars disabled. Enable it in your config file before continuing.</font></li>
    <?php } ?> 
    <li>PHPLIB (is page_open() defined): <?php echo status($phplib) ?></li>
    <?php if ($phplib) { ?>
        <li>I am now going to try to create a HordeSession class. If this line is the last thing that you see, then you do not have class HordeSession defined in the phplib local.inc file. Fix that before proceeding.</li>
        <?php $sess = @new HordeSession;
        if ($sess): ?>
            <li><font color="green">Created a HordeSession instance successfully.</font></li>
            <li><a href="test.php3?mode=phplib-horde">Click here to test PHPLIB for Horde</a> (If this link results in "Document Contains No Data" or "Fatal error...", then you probably have not defined the HordeSession class in the PHPLIB local.inc file).</li>
        <?php endif; ?>
    <?php } ?>
</ul>

<h3>Miscellaneous PHP Settings</h3>
<ul>
    <?php if ($major > 3) { ?>
        <li>register_globals set to On: <?php echo status($register_globals) ?></li>
        <?php if (!$register_globals) { ?>
            <li><font color="red">Horde/IMP require register_globals = on.</font></li>
        <?php } ?>
    <?php } ?>
    <li>magic_quotes_gpc set to Off: <?php echo status($magic_quotes_gpc) ?></li>
    <?php if (!$magic_quotes_gpc) { ?>
        <li><font color="red">magic_quotes_gpc causes data coming from GET, POST, or COOKIE modes to be processed so that single quotes and backslashes are prefixed with a backslash (\'). This makes your email look very ugly. Turn it off. If the PHPLIB installation instructions claim that they want this setting on, they lie - PHPLIB versions 7 and later work perfectly well with it off.</font></li>
    <?php } ?>
    <li>magic_quotes_runtime set to Off: <?php echo status($magic_quotes_runtime) ?></li>
    <?php if (!$magic_quotes_runtime) { ?>
        <li><font color="red">magic_quotes_runtime may not cause quite as many problems as magic_quotes_gpc, but you still do not need it. Turn it off. If the PHPLIB installation instructions claim that they want this setting on, they lie - PHPLIB versions 7 and later work perfectly well with it off.</font></li>
    <?php } ?>
</ul>

</font>

<?php } ?>

</body>
</html>
