# $Id: Warning.pm,v 1.3 1999/04/17 18:15:51 kenji Exp $
package HNS::Hnf::Warning;

use strict;
use HNS::Template;


################################################################
# warning messages
# parameters:
#  c: $cmd_name
#  p: $pos_name

use vars qw($Head $Foot %Messages);
# appended header, footer
$Head = "<br><font color=red>\[- Warning: ";
$Foot = "-\]</font><br>\n";

# message's template
%Messages =
    ('IllegalHeader' => "illegal header.",
     'Reserved' => "command '%c' is reserved. ",
     'NotDefined' => "term '%t' is not defined in %c definition file.",
     'UndefinedUserVar' => 'undefined user variable: %c',
     'NoMatch' => "command '%c' is not allowed in command '%p'. command '%c' is lost ?");

################################################################
sub Message($;$$$)    # static function
{
    my ($kind, $cmd_name, $pos_name, $term) = @_;

#    my $msg = $Messages{$kind};
    my $template = $Messages{$kind};
    if (! exists $Messages{$kind}){
	return "$Head No such Warning Message: $kind $Foot";
    }
    if ($template){
	my $templ = new HNS::Template;
	$template = "$Head$template$Foot";
	return $templ->Expand($template,
			      {c=>$cmd_name, p=>$pos_name,t=>$term});
    } else {
	return '';
    }
}

1;
