#include <strings.h>
#include <gtk/gtk.h>
#include <gtk-xmhtml/gtk-xmhtml.h>
#include <unistd.h>
#include "browser.h"

#include "bwindow_callbacks.h"


guint browser_get_type(void);
static void browser_class_init (BrowserClass *class);
static void browser_init (Browser *b);
GtkWidget* browser_new ();
void browser_clear (Browser *b);

char *welcome_string =
"<html>\n"
"<head><title>Welcome to Express</title></head>\n"
"<body bgcolor=\"#ffffff\">"
"<center>"
"<h1>Welcome to Express</h1>\n"
"</center>"
"<p>"
"<a href=\"http://www.cse.unsw.edu.au/~conradp/express/\">Express Central</a>"
"</body>"
"</html>\n";

guint
browser_get_type ()
{
  static guint b_type = 0;

  if (!b_type)
    {
      GtkTypeInfo b_info =
      {
        "Browser",
        sizeof (Browser),
        sizeof (BrowserClass),
        (GtkClassInitFunc) browser_class_init,
        (GtkObjectInitFunc) browser_init,
        (GtkArgSetFunc) NULL,
        (GtkArgGetFunc) NULL,
      };

      b_type = gtk_type_unique (gtk_vbox_get_type (), &b_info);
    }

  return b_type;
}

enum {
  URL_CHANGED_SIGNAL,
  LAST_SIGNAL
};

static gint browser_signals[LAST_SIGNAL] = { 0 };

static void
browser_class_init (BrowserClass *class)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass*) class;
  
  browser_signals[URL_CHANGED_SIGNAL] = gtk_signal_new ("url_changed",
                                         GTK_RUN_FIRST,
                                         object_class->type,
                                         GTK_SIGNAL_OFFSET (BrowserClass, browser),
                                         gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);


  gtk_object_class_add_signals (object_class, browser_signals, LAST_SIGNAL);

  class->browser = NULL;
}

static void
browser_init (Browser *b)
{
#if 0
  b->text = gtk_text_new(NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(b->text), FALSE);
  gtk_container_add(GTK_CONTAINER(b), b->text);

  /*gtk_signal_connect (GTK_OBJECT (b->text), "pressed",
                      GTK_SIGNAL_FUNC (browser_toggle), b);*/
  gtk_widget_set_usize (b->text, 20, 20);
  gtk_widget_show (b->text);
#endif
  b->html = gtk_xmhtml_new();
  gtk_container_add(GTK_CONTAINER(b), b->html);
  gtk_signal_connect(GTK_OBJECT(b->html), "activate",
                    GTK_SIGNAL_FUNC(gtk_xmhtml_click), b);
  gtk_xmhtml_source(GTK_XMHTML(b->html), welcome_string);
  gtk_widget_show(b->html);
}

GtkWidget*
browser_new ()
{
  return GTK_WIDGET ( gtk_type_new (browser_get_type ()));
}

void           
browser_clear (Browser *b)
{
#if 0
        gtk_signal_handler_block_by_data (GTK_OBJECT(b->text), b);
        gtk_toggle_text_set_state (GTK_TOGGLE_BUTTON (b->text),
                                     FALSE);
        gtk_signal_handler_unblock_by_data (GTK_OBJECT(b->text), b);
#endif
}

#if 0
int browser_set_url(Browser *b, char *url)
{
  FILE *s;
  url_ds u;
  int nread, nhdr=0, nsrc=0;

  u = parse_url(url);
  s = (FILE *)open_url(u);

  if(!s) return FALSE;

  b->buf[0] = '\0';
  if((nread = read((int)s, b->buf, BUF_LEN-1)) == -1) {
    g_print("s: %d\n", (int)s);
    perror("Could not read file descriptor");
    return FALSE;
  }
  b->buf[nread] = '\0';

  switch(u->protocol) {
    case URL_FILE:
      b->src = b->buf;
      nsrc = nread;
      g_print("nsrc: %d\n", nsrc);
      b->hdr = NULL;
      break;
    case URL_HTTP:
      b->hdr = b->buf;
      b->src = strstr(b->buf, "\r\n\r\n") + 2;
      *(b->src) = '\0';
      b->src += 2;
      nsrc = nread - (b->src - b->buf);
      break;
    case URL_FTP:
      b->src = b->buf;
      nsrc = nread;
      b->hdr = NULL;
      break;
    default:
      break;
  }
      
  /* emit the url_changed signal */
  strcpy(b->url, url);
  gtk_signal_emit(GTK_OBJECT(b), browser_signals[URL_CHANGED_SIGNAL]);
}
#endif

int browser_display_src(Browser *b, char *src)
{
  /*int nsrc;*/

/*  b->src = src;*/

  /* display the content */
  if(src) {
#ifdef DEBUG 
    g_print("%s\n", src);
    g_print("===DONE===\n");
    g_print("strlen(src): %d\n", strlen(src));
#endif
    gtk_xmhtml_source(GTK_XMHTML(b->html), src);
  } else {
    g_print("NO SRC\n");
  }

#if 0
  gtk_text_set_point(GTK_TEXT(b->text), 0);
  gtk_text_forward_delete(GTK_TEXT(b->text), gtk_text_get_length(GTK_TEXT(b->text)));

  if(src) {
    nsrc = strlen(src);
    gtk_text_insert(GTK_TEXT(b->text), NULL, NULL, NULL, "Source", 7);
#if 0
    g_print("nsrc: %d\n", nsrc);
    gtk_text_insert(GTK_TEXT(b->text), NULL, NULL, NULL, src, nsrc);
#endif
  }	
#endif

  return TRUE;
}

#if 0
char *browser_get_url(Browser *b)
{
  return (BROWSER(b)->url);
}

char *browser_get_hdr(Browser *b)
{
  return (BROWSER(b)->hdr);
}

char *browser_get_src(Browser *b)
{
  return(BROWSER(b)->src);
}
#endif
