.TH arena 1
.SH NAME
Arena \- X11 based WWW Browser
.SH SYNOPSIS
.B arena
.B [ 
.B [-badflags #]
.B [--maximum-badflags #]
.B [-[no]cache path]
.B [--[no]persistent-cache [path]]
.B [-color]
.B [-color8]
.B [--color (true|dither|mono|grey)]
.B [-[no]cm]
.B [--[no]color-map]
.B [-ct N]
.B [-debug]
.B [--debug [trace-value]]
.B [-display X11_Display]
.B [--display X11_Display]
.B [-editor editor_cmd]
.B [--edit cmd]
.B [-email address]
.B [--e-mail-address address]
.B [--fontsize (large|giant)]
.B [-gamma correction]
.B [--gamma correction]
.B [-geometry +X+Y]
.B [--geometry +X+Y]
.B [-giant]
.B [-grey]
.B [-help|--help]
.B [-icon file.gif]
.B [--application-icon file.gif]
.B [-large]
.B [-lt W3C-Flags]
.B [--libwww-trace [W3C-Flags]]
.B [-lens factor]
.B [--magstep factor]
.B [--magnification factor]
.B [-nomailcap]
.B [--no-mailcap]
.B [-mono]
.B [-printer print_cmd]
.B [--print-command cmd]
.B [--scrollbar-thickness pixels]
.B [-nostyle]
.B [--no-style-sheets]
.B [-noterminal]
.B [--no-terminal]
.B [-url URL]
.B [--url URL]
.B [--usage]
.B [--version]
.B [URL]  ]
.SH DESCRIPTION
\fIArena\fP is an X11 graphical web browser comprised entirely of
\fBfree software\fR.
Its origins predate proprietary packages such as Netscape Navigator,
and Mosaic.
.SH "COMMANDLINE OPTIONS"
.TP 6
.B -badflags max_bad_flags,  --maximum-badflags #
Sets the maximum number of HTML bad flags to be reported when editing
a document.  Bad flags appear as comments in the HTML source.  The default
is 5, the absolute maximum is 50.
.TP 6
.B -nocache,  --no-persistent-cache
Turns client side file caching off.
.TP 6
.B -cache dir,  --persistent-cache dir
Set the cache directory path.  The default is ~/.Arena/cache/
File caching is not yet "actually" persistent.
.TP 6
.B -cm, --color-map
Use a separate colormap.
This avoids \fIArena\fP going into grayscale mode
when other applications are hogging the colours.
.TP 6
.B -color
Use true colour mode.
.TP 6
.B -color8
Use 232 dither mode.
.TP 6
.B --color (true|dither|mono|grey)
Specifies the type of color setup you wish \fIArena\fP to run with.
.TP 6
.B -ct debug_level,  --debug debug_level
Set the value of the debug level.
\fIArena\fP allows the selection of which modules will output
debugging messages.
.TP 6
.B -debug, --debug
Turns on verbose debugging modes.  All modules will report and some modules
will give very detailed messages.
.TP 6
.B -display X11_display,  --display X11_display
Open \fIArena\fP on a display different from DISPLAY environment variable.
.TP 6
.B -editor editor_command,  --edit cmd
Sets the editor command to be used, .e.g. "xterm -e vi".
The value of the EDITOR environment variable is used by default.
When you have finished editing the temporary file that is created, save the file and exit the editor.
\fIArena\fP will then display your edited document.
Your changes will NOT affect the original document unless you specifically use the editor to "save as" and overwrite the original document.
.TP 6
.B -email return_address,  --e-mail-address address
Specifies your email address.
\fIArena\fP will build an email address for you by using USER@FQDN.
If you cannot receive mail at that address, you must specify it yourself.
.TP 6
.B -gamma gamma_correction,  --gamma correction
Set the gamma correction factor.
.TP 6
.B -geometry +X+Y,  --geometry +X+Y
Allows the specification of X11 geometry for
\fIArena\fP at startup.
.TP 6
.B -giant
Use
.B giant
font sizes.
.TP 6
.B --fontsize (large|giant)
Specify the basic font size to be used.
.TP 6
.B -grey
Grayscale mode.
.TP 6
.B -help,  --help
Displays a slightly more detailed list of \fIArena\fP options than --usage.
.TP 6
.B -icon filespec.gif,  --application-icon filespec.gif
Replace default icon in upper right corner of the \fIArena\fP window.
A file or URL pointing to a gif immage can be specified.
.TP 6
.B -lt W3C-Flags,  --libwww-trace W3C-Flags
Specifies the \fIW3C\fP library tracing specification.
.TP 6
.B -large
Use
.B large
font sizes.
.TP 6
.B -lens XFactor,  --magstep XFactor,  --magnification XFactor
Sets the magnification factor which is used to calculate the correct font size.
.TP 6
.B -nomailcap,  --no-mailcap
Do NOT load any mailcap files.
.TP 6
.B -mono
Use monochrome display.
.TP 6
.B -printer print_command,  --print-command cmd
Set the printer command, e.g. "lpr -Plp1".
At the moment \fIArena\fP can only print the HTML source.
.TP 6
.B --scrollbar-thickness pixels
Specify the thickness of the scrollbars in pixels.
.TP 6
.B -nostyle, --no-style
Do NOT take the <STYLE> tag into account when rendering pages.
.TP 6
.B -noterminal,  --no-terminal
Undocumented option.
.TP 6
.B --usage
Displays basic command line usage with available options.
.TP 6
.B -v,  --version
Basic output of current running version of \fIArena\fP.
.TP 6
.B [-url URL],  [--url URL],  [URL]
The initial URL to open.
\fIArena\fP will use the WWW_HOME environment varialbe
unless specified on the command line.
.PP

.SH TOOLBAR ICONS
All toolbar button text labels seem to be quite self explanatory.
\fBHINT\fR: Your mouse has \fB3\fR buttons.

.TP 6
.B Quit
Exit \fIArena\fP...
closing all URL connections and
cleaning up temporary files and
caching directories.
.TP 6
.B Home 
Go to the home web page or default URL.
.TP 6
.B Open
Allows you to enter a URL specification to be opened.
.TP 6
.B Back / Reload / Forward
This single button allows you to move through the
.B history
list.  The left mouse button will go back to the previous document.
The middle button will reload the current document.  The right button will
move to the next document in the history.
.TP 6
.B SaveAs...
Save the current document to disk.  You must then specify the file
specification to be used.
.TP 6
.B View
Toggle viewing HTML source/formatted.
.TP 6
.B Edit
Causes the external editor specified via the
.B --edit-command
command line switch to be used on the current document.
Upon return,
\fIArena\fP will redisplay your edited document.
Your original document is not altered,
unless you used the editor to overwrite it.
.TP 6
.B Print
Print the current document.  At this time, this means just raw text output.  You must specify a --print-command.
.TP 6
.B Zoom In / Out
The left mouse button will redisplay the current document with enlarged fonts.
The right button will redisplay with reduced fonts.  You may zoom in/out more than once.
.TP 6
.B BookMarks  Folder / Index / Add
The left mouse button will open the default bookmark folder.
The middle button will display the bookmark folders index.  When you select
one of the folders, it will then become the current default folder.
The right button will mark the current document URL in the \fIcurrent\fP
default bookmark folder.
.TP 6
.B Help
Will open a default \fIArena\fP Help Page currently located at Yggdrasil.com
.TP 6
.B Abort
Abort the current requested URL.

.SH URL MOUSE BUTTONS
Left button follows the anchor specified.
Middle button show the URL of the targetted anchor.
Right button pops up the History List.

.SH HISTORY LIST
\fIArena\fP keeps a current history list.
By pressing the third (right) mouse button,
you may select the URL from the popup menu.

.SH INITIALIZATION
\fIArena\fP gets its initial options from /usr/share/Arena/arenarc
(this location is system and/or administrator dependent),
then ~/.Arena/arenarc,
then .XDefaults,
and lastly your command line options.  The same option may be specified in each
location.  The closer to the user, the more influence the option setting has.

At the moment, any GNU style option may be specified within each of the
arenarc files.  However, .XDefaults are only available for a very limited set.

.SH BUGS
There are many...
.br
Please report them to the Arena developers mailing list:
\fB<arena-developers@yggdrasil.com>\fR.
.br
.br
Information on subscribing to either list is available by
sending an email message with "help" in the body of the message
to the mailing list processor:
\fB<petidomo@yggdrasil.com>\fR.
Please send all control messages such as "subscribe"
to the list manager.

.SH AUTHORS
.TP 3
.I "Dave Ragget"
<dsr@w3.org>
.br
<www.w3.org/pub/WWW/People/W3Cpeople.html#Raggett>
.TP 3
.I "Hakon W Lie"
<howcome@w3.org>
.br
<www.w3.org/pub/WWW/People/W3Cpeople.html#Lie>
.TP 3
.I "Henrik Frystyk Nielsen"
<frystyk@w3.org>
.br
<www.w3.org/pub/WWW/People/W3Cpeople.html#Frystyk Nielsen>
.TP 3
.I "Yves Lafon"
<lafon@w3.org>
.br
<www.w3.org/pub/WWW/People/W3Cpeople.html#Lafon>
.TP 3
.I "Coordinator"
Yggdrasil \fIArena\fP project coordinator is \fIQingLong\fP
.br
<qinglong@yggdrasil.com>.
.PP

.SH HISTORY
\fIArena\fP has been originally created and been developed by
the W3 Corporation as a testbed browser for (currently) obsolete
HTML3.0 standard. Original \fIArena\fP source code has been covered by
a standard W3C copyright.
In late 1996 it has been given to Yggdrasil Computing Inc.
and all further changes made by Yggdrasil are covered by \fBGNU GPL\fR.
