/*
 * The status bar at the top of the window.
 */



#include <stdio.h>  /* STUPID DIGITAL UNIX!!!!! */
#ifdef __STDC__
#  include <stdarg.h>
# else
#  include <varargs.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/keysym.h>

#include "arena.h"
#include "colour.h"
#include "defs.h"
#ifdef ARENA_DEBUG	/* QingLong.24-01-97 */
#  include "debug.h"
# else
#  include "error.h"
#endif
#include "display.h"
#include "html.h"
#include "main.h"
#include "spawn.h"
#include "scrollbar.h"
#include "status.h"
#include "status_i.h"
#include "toolbar.h"
#include "util.h"
#include "x11.h"


#include "HTUtils.h"	/* WWW general purpose macros */
#include "HTList.h"
#include "HTAccess.h"

#define ARENA_StatusLine_BufferSize 256
#define ActiveTextColour labelColour


Window StatusWin = None;
GC     StatusGC  = NULL;


static char status[ARENA_StatusLine_BufferSize];
int AbortButtonChanged = 0;
Bool AbortButtonUp = True;
int statusOffset;
int cursor; /* position of cursor */

static char readline_finished_str[] = "Arena: got a line from user.";
static Atom Arena_readline_finished = None;

#ifdef SELECTION
int startSelect, stopSelect, beginChr, endChr, textWidth = 1;
Bool selecting = False;
#endif

static int ArenaStatusCharHeight = 0;
static XFontStruct* pStatusFontInfo = NULL;
static XRectangle ArenaStatusLine = {0, 0, 0, 0};


typedef enum {
 InfoMessage,
 ReadLineEchoOn,
 ReadLineNoEcho
} ArenaStatusLineState;


ArenaStatusLineState ArenaStatusLineCurrentState = InfoMessage;


void SetArenaStatusLineFont(XFontStruct* pf)
{
 extern XFontStruct* pStatusFontInfo;

 pStatusFontInfo = pf;
}


Bool SetArenaStatusLineGeometry(XRectangle proposedArenaStatusLine)
{
 if (pStatusFontInfo)
   {
    ArenaStatusCharHeight = (pStatusFontInfo->max_bounds.ascent +
			     pStatusFontInfo->max_bounds.descent);

    ArenaStatusLine.x      = proposedArenaStatusLine.x;
    ArenaStatusLine.y      = proposedArenaStatusLine.y;
    ArenaStatusLine.width  = proposedArenaStatusLine.width;
    ArenaStatusLine.height = ArenaStatusCharHeight;

    if (proposedArenaStatusLine.height > ArenaStatusLine.height)
      ArenaStatusLine.y += ((int)proposedArenaStatusLine.height -
			    (int)ArenaStatusLine.height)/2;

    return True;
   }
  else
   return False;
}


XRectangle GetArenaStatusLineGeometry(void)
{
 return ArenaStatusLine;
}


Bool StatusInit(Window theWindow)
{
 if (theWindow != None && StatusWin == None)
   StatusWin = CreateSubWindow(display, theWindow,
			       ArenaStatusLine.x,     ArenaStatusLine.y,
			       ArenaStatusLine.width, ArenaStatusLine.height,
			       0, windowColour);

 if (StatusWin != None && StatusGC == NULL)
   StatusGC = XCreateGC(display, StatusWin, 0, NULL);

 return ((StatusWin != None) && (StatusGC));
}


static void HandleStatusStringBackup(Bool BackupIt)
{
 static char StatusStringBackupCopy[ARENA_StatusLine_BufferSize] = { '\0' };

 if (BackupIt)
   strncpy(StatusStringBackupCopy, status, ARENA_StatusLine_BufferSize);
  else
   strncpy(status, StatusStringBackupCopy, ARENA_StatusLine_BufferSize);
}


static void BackupStatusString(void)
{
 HandleStatusStringBackup(True);
}


static void RestoreStatusString(void)
{
 HandleStatusStringBackup(False);
}


Bool XDrawArenaStatusString(int theX, int theY,
			    char* theStr, int theStrLen,
			    unsigned long theColour)
{
 if (theStr)
   if ((*theStr) && (theStrLen > 0))
     {
      char* theStatusString = NULL;
      int x, y;
      int theStatusString_len = min(theStrLen, Arena_StrLen(theStr));
      Bool display_StatusLine_raw =
                               (ArenaStatusLineCurrentState != ReadLineNoEcho);

      if (display_StatusLine_raw)
	{
	 theStatusString = theStr;
	}
       else
	{
	 if ((theStatusString = (char*)Arena_MAlloc(theStatusString_len + 1,
						    False)))
	   {
	    int i;
	    char* ip = theStatusString + theStatusString_len;

	    for (i = theStatusString_len, (*ip) = '\0' ; i-- ; ) *(--ip) = '*';
	   }
	}

      x = 2 - statusOffset;
      y = pStatusFontInfo->max_bounds.ascent;

      XSetForeground(display, StatusGC, theColour);
      XDrawString(display, StatusWin, StatusGC, x + theX, y + theY,
		  theStatusString, theStatusString_len);

      if (!display_StatusLine_raw) Free(theStatusString);

      return True;
     }

 return False;
}


void RepairStatus(int x1, int moved)
{
 int x, y, r, n;
 unsigned int w, h;
 XRectangle theXrectangle;


 theXrectangle.x      = x = 0;
 theXrectangle.y      = y = 0;
 theXrectangle.width  = w = ArenaStatusLine.width;
 theXrectangle.height = h = ArenaStatusLine.height;

 if (!moved)
   {
    if (theXrectangle.x < x1)
      {
       theXrectangle.width -= x1 - x;
       theXrectangle.x = x1;
      }
   }

 XSetForeground(display, StatusGC, (ArenaStatusLineActive() ?
                                                statusColour : windowColour));
 XFillRectangle(display, StatusWin, StatusGC, x, y, w, h);

 n = Arena_StrLen(status);

 XDrawArenaStatusString(0, 0,
			status, n,
			(ArenaStatusLineActive() ?
                                 ActiveTextColour : labelColour));

 r = XTextWidth(pStatusFontInfo, status, cursor);

 if (ArenaStatusLineActive())   /* draw cursor */
   {
    XSetForeground(display, StatusGC, strikeColour);
    XFillRectangle(display, StatusWin, StatusGC,
		   x + 1 + r - statusOffset, y,
		   1, h);
   }
}


/*
 * Set/Clear status bar state. Returns if the state has actually been set.
 * Will reset the state only if the current state matches the requested one.
 * Will switch to the requested state only if the current is `zero' (default).
 * Be aware: ``InfoMessage'' is used as `zero' (deafult) state (when reset).
 */
static Bool setArenaStatusLineState(ArenaStatusLineState theState, Bool set)
{
 Bool setSuccessfully;
#ifdef ARENA_DEBUG
 char Iam[] = "setArenaStatusLineState";
#endif


 if (set)
   {
    if (ArenaStatusLineCurrentState == InfoMessage)
      {
       ArenaStatusLineCurrentState = theState;
       setSuccessfully = True;
      }
     else
      {
#ifdef ARENA_DEBUG
       if (STATUS_TRACE)
	 Arena_TracePrint(Iam,
			  " ERROR! Illegal switching state: %d -> %d.\n",
			  ArenaStatusLineCurrentState, theState);
#endif
       setSuccessfully = False;
      }
   }
  else
   {
    if (ArenaStatusLineCurrentState == theState)
      {
       ArenaStatusLineCurrentState = InfoMessage;
       setSuccessfully = True;
      }
     else
      {
#ifdef ARENA_DEBUG
       if (STATUS_TRACE)
	 Arena_TracePrint(Iam,
			  " ERROR! Resetting state %d, while actually %d.\n",
			  theState, ArenaStatusLineCurrentState);
#endif
       setSuccessfully = False;
      }
   }

 return setSuccessfully;
}


Bool ArenaStatusLineActive(void)
{
 return (ArenaStatusLineCurrentState != InfoMessage);
}


void ArenaStatusLineDesactivate(void)
{
 ArenaStatusLineCurrentState = InfoMessage;
}


void XDrawArenaStatus(void)
{
 int n;


 XSetForeground(display, StatusGC, (ArenaStatusLineActive() ?
				                statusColour : windowColour));
 XFillRectangle(display, StatusWin, StatusGC,
		0, 0, ArenaStatusLine.width, ArenaStatusLine.height);

 if ((n = Arena_StrLen(status)))
   {
    XDrawArenaStatusString(0, 0, status, n,
			   (ArenaStatusLineActive() ?
			            ActiveTextColour : labelColour));

#ifdef SELECTION
    /*
     * howcome 2/8/94:
     * added code to draw highlighted strings.
     * b (=beginChr) and e (=endChr) contains the indexes
     * to start  and stop of highlighted chars in status string 
     */

    if (beginChr > 0)
      XDrawArenaStatusString(0, 0,
			     status,
			     min(n, beginChr),
			     labelColour);

    if (beginChr < n)
      XDrawArenaStatusString((beginChr * textWidth), 0,
			     (status + min(n, beginChr)),
			     (min(n, endChr) - min(n, beginChr)),
			     strikeColour);

    if (endChr < n)
      XDrawArenaStatusString((endChr * textWidth), 0,
			     (status + min(n, endChr)),
			     (n - min(n, endChr)),
			     labelColour);
#endif /* SELECTION */

    if (ArenaStatusLineActive())   /* draw cursor */
      {
       int r = XTextWidth(pStatusFontInfo, status, cursor);

       XSetForeground(display, StatusGC, strikeColour);
       XFillRectangle(display, StatusWin, StatusGC,
		      r + 1 - statusOffset, 0, 1, ArenaStatusLine.height);
      }
   }
}


void DisplayStatusLine(void)
{
 DisplayStatusLine_withLabel(NULL);
}


#ifdef SELECTION
/* howcome added SelectStatus 1/8/94 */

void SelectStatus(int x_in, int y_in)
{
 int x, y;


 if (selecting)
   {
    x = 50;
    y = win_height - 10 - ArenaStatusCharHeight;
    stopSelect = (x_in - x) / textWidth;
    stopSelect = max(0, stopSelect);

    beginChr = min(startSelect, stopSelect);
    endChr   = max(startSelect, stopSelect);

    DisplayStatusLine();
   }
}

#endif /* SELECTION */


static void SetStatusString(char *theStatusString)
{
 int r, n;


 if (initialised)
   {
    if ((n = Arena_StrLen(theStatusString)))
      {
       strncpy(status, theStatusString, ARENA_StatusLine_BufferSize - 1);
       status[ARENA_StatusLine_BufferSize - 1] = '\0';

       /* trim trailing \r\n */

       n--;

       if (n > 0 && status[n] == '\n')
	 {
	  status[n--] = '\0';

	  if (status[n] == '\r') status[n] = '\0';
	 }
      }
     else
      status[0] = '\0';

    if (!UpdateToolBarGeometry()) return;

    XSetForeground(display, StatusGC, windowColour);

    if (AbortButtonChanged)
      {
       DrawToolBarButton((AbortButtonUp ? Arena_Button_UP : Arena_Button_DOWN),
			 0);
       AbortButtonChanged = 0;  /* avoid flickering buffer */
      }

    XSetForeground(display, StatusGC, 
		   ((ArenaStatusLineActive()) ? statusColour : windowColour) );
    XFillRectangle(display, StatusWin, StatusGC,
		   0, 0, ArenaStatusLine.width, ArenaStatusLine.height);

    cursor = n = Arena_StrLen(status);

    XDrawArenaStatusString(0, 0,
			   status, n,
			   (ArenaStatusLineActive() ?
                                    ActiveTextColour : labelColour));

    r = XTextWidth(pStatusFontInfo, status, cursor);

    if (ArenaStatusLineActive())   /* draw cursor */
      {
       XSetForeground(display, StatusGC, strikeColour);
       XFillRectangle(display, StatusWin, StatusGC,
		      r +1 - statusOffset, 0, 1, ArenaStatusLine.height);
      }
   }
  else
   if (theStatusString)
     {
      strncpy(status, theStatusString, ARENA_StatusLine_BufferSize-1);
      status[ARENA_StatusLine_BufferSize-1] = '\0';

      /* trim trailing \r\n */

      n = Arena_StrLen(status) - 1;

      if (n > 0 && status[n] == '\n')
        {
	 status[n--] = '\0';

	 if (status[n] == '\r') status[n] = '\0';
        }

      cursor = Arena_StrLen(status);

#ifdef SELECTION
      ClearStatusSelection();
#endif
     }

 XFlush(display); /* howcome 5/10/94: this seems to be required */
}


#ifdef SELECTION
void ClearStatusSelection(void) /* howcome 2/8/94 */
{
 beginChr = 0;
 endChr = 0;
}
#endif


void ClearStatus(void)
{
 cursor = 0;
 status[0] = '\0';
 statusOffset = 0;
#ifdef SELECTION
 beginChr = 0;
 endChr = 0;
#endif
}


/*
 * Takes proper editing actions. Returns whether the char was `editing' one.
 */
Bool EditChar(char c)
{
/* x1 is position of cursor, x2 is right edge of clipped text */
 int i, n, x1, x2, moved;
#ifdef ARENA_DEBUG
 char Iam[] = "EditChar";
#endif


 n = Arena_StrLen(status);

 if (!ArenaStatusLineActive())
   {
    Beep();
    return False;
   }

 switch (c)
   {
    case '\0':
      return False;
      break;

    case '\b':
      if (cursor > 0)
        {
	 --cursor;
	 strcpy(status + cursor, status + cursor + 1);
	 x1 = 2 + XTextWidth(pStatusFontInfo, status, cursor);
	 x2 = ArenaStatusLine.width;
	 n = (x1 > x2 ? x1 - x2 : 0);
	 moved = ( (n == statusOffset) ? 0 : 1);
	 statusOffset = n;
	 RepairStatus(x1 - statusOffset - 1, moved);
        }
       else
	Beep();

      return True;
      break;

    case 0x15:
      /* Ctrl-U */
      ClearStatus();
      RepairStatus(statusOffset, 1);
      return True;
      break;

    case 0x7f:
      /* Delete */
      if (cursor < Arena_StrLen(status))
	{
	 strcpy(status+cursor, status+cursor+1);
	 x1 = 2 + XTextWidth(pStatusFontInfo, status, cursor);
	 x2 = ArenaStatusLine.width;
	 n = (x1 > x2 ? x1 - x2 : 0);
	 moved = ( (n == statusOffset) ? 0 : 1);
	 statusOffset = n;
	 RepairStatus(x1 - statusOffset - 1, moved);
	}
       else
        Beep();

      return True;
      break;

    case '\n':
    case '\r':
      switch (ArenaStatusLineCurrentState)
	{
	 case InfoMessage:
	   break;

	 case ReadLineEchoOn:
	 case ReadLineNoEcho:
	   HideBusy();
#ifdef SELECTION
	   beginChr = endChr = 0; /* howcome */
#endif
	   {
	    XEvent theNotification;

#ifdef ARENA_DEBUG
	    if (X_TRACE)
	      Arena_TracePrint(Iam, " sending \"Arena_readline_finished\".\n");
#endif
	    theNotification.type = ClientMessage;
	    theNotification.xclient.window = StatusWin;
	    theNotification.xclient.message_type = Arena_readline_finished;
	    theNotification.xclient.format = 8;
	    XSendEvent(display, StatusWin, False, NoEventMask,
		       &theNotification);
	    XFlush(display);
	   }
	   return True;
	   break;
	}
      return False;
      break;

    default:
      if (isprint(c))
	{
	 if (n < ARENA_StatusLine_BufferSize-1)
	   {
	    for (i = n; i >= cursor; --i) status[i+1] = status[i];

	    status[cursor++] = c;

	    x1 = 3 + XTextWidth(pStatusFontInfo, status, cursor);
	    x2 = ArenaStatusLine.width - 4;

	    n = (x1 > x2 ? x1 - x2 : 0);
	    moved = ((n == statusOffset) ? 0 : 1);
	    statusOffset = n;
	    RepairStatus(x1 - statusOffset - XTextWidth(pStatusFontInfo,
							&c, 1), moved);
	   }
	  else
	   Beep();

	 return True;
	}
       else
	return False;

      break;
   }

 return False;
}


void MoveStatusCursor(int key)
{
 int was, x1, x2, moved = 0, r, n;


 was = cursor;

 if (key == XK_Left)
   {
    if (cursor > 0)
      {
       --cursor;
       x1 = 2 + XTextWidth(pStatusFontInfo, status, cursor);
       x2 = ArenaStatusLine.width;
       n = (x1 > x2 ? x1 - x2 : 0);
       moved = ( (n == statusOffset) ? 0 : 1);
       statusOffset = n;
       if (moved) RepairStatus(x1 - statusOffset - 1, moved);
      }
     else
      Beep();
   }
  else
   if (key == XK_Right)
     {
      if (cursor < Arena_StrLen(status))
        {
	 ++cursor;
	 x1 = 1 + XTextWidth(pStatusFontInfo, status, cursor);
	 x2 = ArenaStatusLine.width;
	 n = (x1 > x2 ? x1 - x2 : 0);
	 moved = ( (n == statusOffset) ? 0 : 1);
	 statusOffset = n;

	 if (moved)
	   RepairStatus(x1 - statusOffset - XTextWidth(pStatusFontInfo,
						       status + cursor - 1, 1),
			moved);
        }
       else
	Beep();
     }

 if (!moved && was != cursor)
   {
    XSetForeground(display, StatusGC, statusColour);
    r = XTextWidth(pStatusFontInfo, status, was);
    XFillRectangle(display, StatusWin, StatusGC,
		   r + 1 - statusOffset, 0, 1, ArenaStatusLine.height);

    XSetForeground(display, StatusGC, strikeColour);
    r = XTextWidth(pStatusFontInfo, status, cursor);
    XFillRectangle(display, StatusWin, StatusGC,
		   r + 1 - statusOffset, 0, 1, ArenaStatusLine.height);
   }
}


#define Arena_ANNOUNCE_BUFFER_CAPACITY	(512 - 1)
void Announce(char *args, ...)
{
 char* aMessage;
 char buf[Arena_ANNOUNCE_BUFFER_CAPACITY+1];
#ifdef ARENA_DEBUG
 char Iam[] = "Announce";
#endif


 if (args)
   {
    va_list ap;

    va_start(ap, args);
#ifdef HAVE_VSNPRINTF
    vsnprintf(buf, Arena_ANNOUNCE_BUFFER_CAPACITY, args, ap);
# else
    vsprintf(buf, args, ap);
#endif
    va_end(ap);

    aMessage = buf;

#ifdef ARENA_DEBUG	/* QingLong.23-01-97 */
    if (STATUS_TRACE) Arena_TracePrint(Iam, " %s\n", aMessage);
#endif
   }
  else
   {
    aMessage = NULL;

#ifdef ARENA_DEBUG	/* QingLong.23-01-97 */
    if (STATUS_TRACE) Arena_TracePrint(Iam, " NULL message.\n");
#endif
   }

 if (!ArenaStatusLineActive())
   {
    SetStatusString(aMessage);

    if (initialised)
      {
       XFlush(display);
      }
   }
}
#undef Arena_ANNOUNCE_BUFFER_CAPACITY


#define Arena_WARN_BUFFER_CAPACITY	(512 - 1)
void Warn(char *args, ...)
{
 char* wMessage;
 char buf[Arena_WARN_BUFFER_CAPACITY];
#ifdef ARENA_DEBUG
 char Iam[] = "Warn";
#endif


 if (args)
   {
    va_list ap;

    va_start(ap, args);
#ifdef HAVE_VSNPRINTF
    vsnprintf(buf, Arena_WARN_BUFFER_CAPACITY, args, ap);
# else
    vsprintf(buf, args, ap);
#endif
    va_end(ap);

    wMessage = buf;

#ifdef ARENA_DEBUG	/* QingLong.23-01-97 */
    if (STATUS_TRACE) Arena_TracePrint(Iam, " %s\n", wMessage);
# else
    Arena_PrintError(" %s\n", wMessage);
#endif
   }
  else
   {
    wMessage = NULL;

#ifdef ARENA_DEBUG	/* QingLong.23-01-97 */
    if (STATUS_TRACE) Arena_TracePrint(Iam, " NULL message.\n");
#endif
   }

 if (!ArenaStatusLineActive())
   {
    SetStatusString(wMessage);

    if (initialised)
      {
       XFlush(display);
      }
   }
}
#undef Arena_WARN_BUFFER_CAPACITY


/*
 * CurrentDoc->tag is used ONLY for this routine to know which named
 * fragment tag to display as part of the URL.
 * Since multiple anchors (including ChildAnchors) may be using Doc->
 * Doc can only store the "basic" URL.
 * Each time an anchor is "loaded/opened", it will SET Doc->tag to
 * the fragment tag of THAT anchor...
 * Hence, we can display the "correct" URL here!
 * The #tag of the ``original anchor that loaded this document'' is lost!
 * But that is not a problem,
 * since Doc->request will get you that information...
 * if you really need it!
 */
void DisplayUrl(Doc* theDoc)
{
 if (theDoc)
   {
    if (theDoc && theDoc->url)
      {
       if (theDoc->tag)
	 Announce("%s#%s", theDoc->url, theDoc->tag);
        else
	 Announce("%s", theDoc->url);
      }
   }
}


/*
 * Callback function for X events sifting.
 */
static Bool Arena_readline_notificationXEvent(Display*  theDisplay,
					      XEvent*  theXEventP,
					      XPointer theXPointer)
{
 if (theDisplay == display)
   if (theXEventP->type == ClientMessage)
     if (theXEventP->xclient.window == StatusWin)
       if (theXEventP->xclient.message_type == Arena_readline_finished)
	 return True;

 return False;
}


/*
 * X events handler in the status line context. (logical, not graphic :)
 */
Bool StatusLineDialog(XEvent* theXEventP)
{
 if (ArenaStatusLineActive())
   {
    switch (theXEventP->type)
      {
       case ClientMessage:
	 if (Arena_readline_notificationXEvent(display, theXEventP, NULL))
	   {
	    XPutBackEvent(display, theXEventP);
	    return True;
	   }
	 break;

       case KeyPress:
	 {
	  int count;
#define ARENA_StatusLineDialog_KeyBuf_Size 64
	  int  KeyBuf_s = ARENA_StatusLineDialog_KeyBuf_Size - 1;
	  char KeyBuf[ARENA_StatusLineDialog_KeyBuf_Size];
#undef  ARENA_StatusLineDialog_KeyBuf_Size
	  KeySym theKey;
	  XComposeStatus theComposeStatus;


	  count = XLookupString((XKeyEvent*)theXEventP,
				KeyBuf, KeyBuf_s, &theKey, &theComposeStatus);

	  if (count >= 0)
	    {
	     KeyBuf[count] = 0;

	     switch (theKey)
	       {
	        case XK_Left:
	        case XK_Right:
		  MoveStatusCursor(theKey);
		  return True;
		  break;

#if (XK_DeleteChar != XK_Delete)
	        case XK_DeleteChar:
#endif
	        case XK_Delete:
		  return EditChar(0x7f);
		  break;

#ifdef _HPUX_SOURCE
	        case XK_ClearLine:
	        case XK_DeleteLine:
		  ClearStatus();
		  SetStatusString(NULL); /* force refresh */
		  return True;
		  break;
#endif

	        case XK_Escape:
		  if (Busy())
		    Beep();
		   else
		    {
		     ClearStatus();
		     EditChar('\n');
		    }
		  return True;
		  break;

	        default:
		  if (count > 0)
		    {
		     char* cp;

		     for (cp = KeyBuf; (*cp); cp++)
		       if (!EditChar(*cp)) return False;

		     return True;
		    }
		  break;
	       }
	     /* End ``switch (theKey)'' */
	    }
	  /* End ``if (count >= 0)'' */
	 }
         break;

       default:
	 break;
      }
    /* End ``switch (theXEvent->type)'' */
   }
 /* End ``if (StatusLineActive())'' */

 return False;
}


/*
 * Prompt user for input. Caller should Free() the returned answer string.
 */
char* ArenaPromptUser(char* thePrompt, char* InitString, Bool echo)
{
 char* theUserAnswer;
 XEvent theXEvent;
#ifdef ARENA_DEBUG
 char Iam[] = "ArenaPromptUser";
#endif


 if (Arena_readline_finished == None)
   {
    Arena_readline_finished = XInternAtom(display,
					  readline_finished_str,
					  False);
    if (Arena_readline_finished == None) return NULL;
   }

#ifdef ARENA_DEBUG
 if (STATUS_TRACE)
   Arena_TracePrint(Iam,
		    " Ask for \"%s\" (echo o%s),\n\tinitial: \"%s\"\n",
		    thePrompt ? thePrompt : "", echo ? "n" : "ff",
		    InitString ? InitString : "");
#endif

 setArenaStatusLineState(echo ? ReadLineEchoOn : ReadLineNoEcho, True);
#ifdef SELECTION
 ClearStatusSelection();
#endif
 BackupStatusString();
 SetStatusString(InitString);
 DisplayStatusLine_withLabel(thePrompt);

 while (!XCheckIfEvent(display,
		       &theXEvent, Arena_readline_notificationXEvent, NULL))
   {
    GuiEvents(0, NULL, 0);
    XPeekEvent(display, &theXEvent);
   }

#ifdef ARENA_DEBUG
 if (X_TRACE) Arena_TracePrint(Iam, " readline finished.\n");
#endif

 theUserAnswer = (Arena_StrLen(status)) ? strdup(status) : NULL;
 setArenaStatusLineState(echo ? ReadLineEchoOn : ReadLineNoEcho, False);
 RestoreStatusString();
 DisplayStatusLine();

#ifdef ARENA_DEBUG
 if (STATUS_TRACE)
   Arena_TracePrint(Iam,
		    "\n"
		    "\tAsked \"%s\" (echo o%s),\n"
		    "\tgot \"%s\".\n",
		    thePrompt ? thePrompt : "", echo ? "n" : "ff",
		    theUserAnswer ? theUserAnswer : "");
#endif

 return theUserAnswer;
}


int StatusButtonDown(int button, int px, int py)
{
 if (button == Button1)
   {
#ifdef SELECTION
 /* howcome 1/8/94 */
    textWidth = XTextWidth(pStatusFontInfo, " ", 1);
    if (textWidth > 0)
      {
       startSelect = (px - 50 - 4) / textWidth;	/* 50 should be a define */
       /* startSelect = min(startSelect,Arena_StrLen(status));*/
       if (startSelect >= 0)
	 { 
	  beginChr = endChr = startSelect;
          selecting = True;
	 }
      }
#endif
    return STATUS;
   }


 /* now check for middle or right button down over status window */

 if ((button == Button2 || button == Button3))
   {
    int n;
    char* s = XFetchBytes(display, &n);

    s = strtok(s, "\n");
    n = Arena_StrLen(s);

    if (s)
      {
       int l = Arena_StrLen(status);
       {
	int nt = ARENA_StatusLine_BufferSize - 1;

	if (n > nt) n = nt;
       }
       strncpy(status + l, s, n);
       status[l + n] = '\0';
       cursor = l + n;
       XFree(s);
      }
   }

#ifdef SELECTION
 return STATUS; /* howcome 1/8/94: indicate interest in buttonup since user may select (part of) url */
# else
 return VOID;
#endif
}


void StatusButtonUp(int px, int py)
{
 /* If there is a child waiting on us in GUI mode...
  * We've just redrawn the button as UP... now don't let anything else happen.
  */
 if (SpawnIsWaitGui()) return;

#ifdef SELECTION
 if (selecting)	/* howcome 1/8/94 */
   {
    char *s;
    const int n = Arena_StrLen(status);

    if (beginChr > n && endChr > n)	/* off bounds, select everything */
      {
       beginChr = 0;
       endChr = Arena_StrLen(status);
      }

    if (beginChr == endChr && beginChr < n)
      {
       char *pb, *pe;

       pb = pe = status + beginChr;	/* search for sensible strings */
       while(pb >= status && *pb != ':' && *pb !='/') pb--;
       pb++;
       while(*pe != '\0' && *pe != ':' && *pe !='/') pe++;

       beginChr = pb - status;
       endChr = pe - status;
      }

    if (beginChr > endChr)
      /* this happens to be true when a ':' of '/' has been pressed,
	 select everything */
      {
       beginChr = 0;
       endChr = n;
      }

    endChr = min(n, endChr); /* howcome 8/3/95 */

    s = strdup(status);
    strncpy(s, status + beginChr, endChr - beginChr);
    s[endChr-beginChr] = '\0';

#ifdef ARENA_DEBUG	/* QingLong.23-01-97 */
    if (STATUS_TRACE)
      Arena_TracePrint("StatusButtonUp", " Set selection: \"%s\"\n", s);
#endif

    DisplayStatusLine();

    SetSelection(s);
    Free(s);
    selecting = False;
   }
#endif /* SELECTION */
}
