// Mntent.h. Header file for c++ after mntent.h for Linux. -*- C++ -*-
// (c) 1996, 1997 David A. van Leeuwen
//
// Actually contains code that might be in a separate .cc file. But
// this is a derivative of c, so the inline functions belong in this
// .h file.


#include <String.h>
#include <mntent.h>

#ifndef MNTTYPE_ISO9660
#define MNTTYPE_ISO9660 "iso9660"
#endif

class Mntent {				// mnt_* isn't necessary, is it?
public:
     String fsname, dir, type, opts;
     int freq, passno;
     Mntent(struct mntent * mep);	// constructor from c-mntent
     struct mntent * mntent();		// static pointer to c-representation
     operator struct mntent * ();	// conversion to c-mntent
     // ~Mntent();			// use default destructors
};

inline 
Mntent::Mntent(struct mntent * mep) 
{
#define x(a) a = String(mep->mnt_ ## a)
     x(fsname); x(dir); x(type); x(opts);
#undef x
     freq = mep->mnt_freq; passno = mep->mnt_passno;
}

// The following ugly code is necessary to make it possible to use a
// variable of type Mntent in a function where mntent* is expected
// (the normal system routines).  The String -> char* conversion is
// only automatic for `const char *', and (const char *) -> char*
// discards const. Too bad it does. Hope the system routines don't
// change the contents of our Sting...
inline char * charp(const char * c)
{
     return (char *) (void *) c;
}

// explicit type conversion Mntent -> mntent*
inline struct mntent * Mntent::mntent()
{
     static struct mntent entry;
#define x(a,typef) entry.mnt_ ## a = typef(a)
     x(fsname, charp); x(dir, charp); 
     x(type, charp); x(opts, charp);
     x(freq, int); x(passno, int);
#undef x
     return &entry;
}

// implicit type conversion
inline Mntent::operator mntent * ()
{
     return this->mntent();
}

// inline Mntent::~Mntent(void)

//
// Local Variables:
// c-file-style: "K&R"
// comment-column: 40
// End:
// 






