/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#include "vfu.h"
#include "vfufiles.h"
#include "vfuopt.h"
#include "vfuview.h"
#include "vfumenu.h"
#include "vfudir.h"

/////////////////////////////////////////////////////////////////////////////
//
// returns stat type
//

static char __file_stat_type_buf[3];
const char* FileStatType( mode_t mode, int is_link )
{
  strcpy(__file_stat_type_buf, "--");
  if (S_ISDIR(mode) && is_link)
                      strcpy(__file_stat_type_buf, "<>"); else
  if (S_ISBLK(mode) ) strcpy(__file_stat_type_buf, "=="); else
  if (S_ISCHR(mode) ) strcpy(__file_stat_type_buf, "++"); else
  if (S_ISFIFO(mode)) strcpy(__file_stat_type_buf, "()"); else
  if (S_ISSOCK(mode)) strcpy(__file_stat_type_buf, "##"); else
  if (is_link       ) strcpy(__file_stat_type_buf, "->"); else
  if (S_ISDIR (mode)) strcpy(__file_stat_type_buf, "[]"); else
  if ((mode & S_IXOTH)||(mode & S_IXGRP)||(mode & S_IXUSR))
                      strcpy(__file_stat_type_buf, "**"); else
  ;
/*
  #ifdef _TARGET_GO32_
  if (__file_stat_type_buf[0] == '-')
    {
    FileExt( fitem->name, sss);
    if ( PathCmp( sss, "EXE" ) == 0 || PathCmp( sss, "COM" ) == 0 )
      strcpy( fitem->sttype, "**" );
    }
  #endif
  fitem->sttype[2] = 0;
*/
  return __file_stat_type_buf;
}

/////////////////////////////////////////////////////////////////////////////
//
//  return 0 for ok
//
int MatchFMASK( const char* fname )
{
  int z;
  for(z = 0; z < MAX_FMASKS; z++)
    if (FMASKARRAY[z][0] != 0 && FNMATCH(FMASKARRAY[z],fname) == 0) return 0;
  return 1;
}
/////////////////////////////////////////////////////////////////////////////
//
//
//

void ReadFiles( int rfmode, int savesel, PSZCluster *sc )
{
  say1( "Rescanning files..." );

  int z;

  String saves = "";

  if ( savesel && opt.PreserveSelection && SelCount > 0 )
    {
    saves += ":";
    for ( z = 0; z < FilesCount ; z++)
      if ( Files[z]->sel )
        {
        saves += Files[z]->name;
        saves += ":";
        }
    }

  for ( z = 0; z < MaxFiles ; z++) if (Files[z]) { delete Files[z]; Files[z] = NULL; }

  SelCount   = 0;  SelSize    = 0;  AllSize    = 0;  FilesCount = 0;

  if ( WorkMode == wmNormal    )
    {
    if ( sc ) ReadPSZFiles( sc ); else
    if ( rfmode == RF_RECURSIVE ) ReadRecursiveFiles(); else
    if ( StrGetCh(FMASK, -1 ) == '|' ) ReadExternalFiles(); else
    ReadDirectoryFiles();
    } else
  if ( WorkMode == wmInArchive ) ReadArchiveFiles();

  UpdateStats();

  if ( savesel && opt.PreserveSelection && StrLen( saves ) > 0 )
    {
    for ( z = 0; z < FilesCount ; z++ )
      {
      char tmp[MAX_PATH];
      strcpy( tmp, ":" );
      strcat( tmp, Files[z]->name );
      strcat( tmp, ":" );
      if ( StrFind( saves, tmp ) != -1 )
        Files[z]->sel = 1;
      }
    UpdateStats();
    }

  say1( "" );
  UpdatePos();
  ReSortFiles( 0 );
 // if (FLI == -1) FLI = 0;
  RefreshAllViews();
  // get filesystem free space
  StatFS();
}

/////////////////////////////////////////////////////////////////////////////
//
// ReadDirectoryFiles...
//

// type is FTWALK_xxx from the vfuuti.h
int AddFilesItem( const char* fname, struct stat *st = NULL, int type = 0 )
{
  struct stat _st;
  struct stat _lst;

  if ( strcmp( fname, "." ) == 0 || strcmp( fname, ".." ) == 0 ) return 0;
  if ( opt.HideDotNames && fname[0] == '.' ) return 0;

  if ( st == NULL || type == 0 )
    {
     stat( fname, &_st );
    lstat( fname, &_lst );
    type = FTWALK_F;
    if (S_ISDIR( _st.st_mode )) type  = FTWALK_D;
    if (S_ISLNK(_lst.st_mode)) type += FTWALK_L;
    st = &_st;
    };
    

  TF* fi = new TF;

  strcpy(fi->name, fname);
  fi->fname = strrchr( fi->name, '/' );
  if ( fi->fname ) fi->fname++; else fi->fname = fi->name;

  fi->is_link = int( (type & FTWALK_L) != 0 );
  memcpy(&(fi->st), st, sizeof(struct stat));

  fi->sel = 0;
  fi->is_dir = int( (type & FTWALK_D) != 0 ); // S_ISDIR(fi->st.st_mode);
  if (fi->is_dir)
    {
    fi->size = -1;
    if ( opt.DirTreeSizes )
      {
      if (fi->is_link)
        {
        ExpandPath( fi->name, sss );
        strcat( sss, "/" );
        }
      else
        {
        strcpy( sss, CPath );
        strcat( sss, fi->name );
        strcat( sss, "/" );
        }
      fi->size = DirTreeGetSize( sss );
      }
    }
  else
    fi->size = fi->st.st_size;

  // strcpy( fi->sttype, FileStatType( fi->st.st_mode, fi->is_link ) );
  fgetattr_s( fi->name, fi->stmode );

  AllSize += fi->size;

  Files[FilesCount] = fi;
  FilesCount++;
  if ( FilesCount >= MaxFiles ) return 1;

  if ( FilesCount % 1024 == 0 )
    {
    char tmp[32];
    sprintf(tmp, "Rescanning files... (%d)  ", FilesCount);
    say1( tmp );
    }
  return 0;
}

// filter through FMASK
int FilterAddFilesItem( const char* fname, struct stat *st, int type )
{
  if (!S_ISDIR(st->st_mode))
    if (MatchFMASK( fname ))
      return 0;
  return AddFilesItem( fname, st, type );
}
/////////////////////////////////////////////////////////////////////////////
//
//
//

void ReadDirectoryFiles()
{
  DIR *dir;
  dirent *de;
  struct stat st;
  struct stat lst;

//  say1("Reading...");
  dir = opendir(".");
  if (!dir) return;
  while( (de = readdir(dir)) )
    {
    if (BreakOp()) break;

    if ((de->d_name[0] == '.' && de->d_name[1] == 0) ||
        (de->d_name[0] == '.' && de->d_name[1] == '.' &&de->d_name[2] == 0))
        continue;

    lstat(de->d_name, &lst);
    #ifdef _TARGET_GO32_
    dosstat(dir, &st);
    #else
    stat(de->d_name, &st);
    #endif
    int flag = FTWALK_F;
    if (S_ISDIR(st.st_mode)) flag  = FTWALK_D;
    if (S_ISLNK(lst.st_mode)) flag += FTWALK_L;

    if (FilterAddFilesItem( de->d_name, &st, flag )) break;
    }
 closedir(dir);


 if ( FilesCount == 1 && FNMATCH( Files[0]->name, "automount" ) == 0 )
   {
   String str = CPath;
   chdir( "/" );
   str = "mount " + str + " 2> /dev/null";
   sprintf( sss, "AutoMount point detected, exec: %s", str.asis() );
   say1( sss );
   int err;
   if ( (err = system( str )) == 0)
     {
     //---------------
     delete Files[0];
     Files[0] = NULL;
     SelCount = 0;
     SelSize = 0;
     AllSize = 0;
     FilesCount = 0;
     //---------------
     chdir( CPath );
     ReadDirectoryFiles();
     }
   else
     {
     sprintf( sss, "AutoMount failed: exit code: %d ( press ESC )", err );
     say1( sss );
     ConBeep();
     ConGetch();
     }
   }
};

/////////////////////////////////////////////////////////////////////////////
//
//
//

void ReadRecursiveFiles()
{
  say1( "Rescanning files...(recursive)" );
  ftwalk( ".", AddFilesItem, -1 );
};

/////////////////////////////////////////////////////////////////////////////
//
//
//

void ReadExternalFiles()
{
  char tmp[MAX_PATH+1];
  char tmp1[MAX_PATH+1];
  strcpy( tmp, FMASK );
  ASSERT( tmp[ StrLen( tmp ) - 1 ] == '|' );
  StrTrimR( tmp, 1 );

  say1( "Rescanning files...(external)" );
  FILE *f = popen( tmp, "r" );
  while( fgets( tmp, MAX_PATH, f ) )
    {
    StrCut( tmp, " \t\n\r" );

    while( StrGetFirstWord( tmp, " \t:;", tmp1 ) )
      {
      if (access( tmp1, F_OK )) continue;

      struct stat st;
      struct stat lst;
      stat( tmp1, &st );
      lstat( tmp1, &lst );
      int flag = FTWALK_F;
      if (S_ISDIR(st.st_mode)) flag  = FTWALK_D;
      if (S_ISLNK(lst.st_mode)) flag += FTWALK_L;
      
      if (AddFilesItem( tmp1, &st, flag ))
        {
        pclose(f);
        return;
        }
      }
    }
  pclose( f );
};

/////////////////////////////////////////////////////////////////////////////
//
//
//
void ReadPSZFiles( PSZCluster* sc )
{
  int z;
  for ( z = 0; z < sc->count(); z++ )
    AddFilesItem( (*sc)[ z ] );
};

/////////////////////////////////////////////////////////////////////////////
//
// Pack
//

void Pack()
{
  int pos  = 0;
  int next = 0;

  while( pos < FilesCount )
    {
    if ( Files[pos] == NULL )
      {
      next = pos + 1;
      while ( next < FilesCount && Files[next] == NULL ) next++;
      if ( next < FilesCount && Files[next] != NULL )
        {
        Files[pos] = Files[next];
        Files[next] = NULL;
        }
      else
        break;
      }
    else
      pos++;
    }
  FilesCount = 0;
  while ( FilesCount < MaxFiles && Files[FilesCount] != NULL ) FilesCount++;
  UpdateStats();
  UpdatePos();
  draw = 1;
}

/////////////////////////////////////////////////////////////////////////////
//
// arrange/sort files
//

// this compares Name20 and Name3 and returns second as smaller :) (or so)...
int namenumcmp( const char* s1, const char* s2 )
{
  int s1l = strlen( s1 );
  int s2l = strlen( s2 );
  int z;
  for ( z = 0; z < ( s1l < s2l ? s1l : s2l ); z++ )
    if ( s1[z] != s2[z] ) break;
  if ( z == s1l && z == s2l ) return 0;
  if ( z == s1l ) return -1;
  if ( z == s2l ) return  1;
  String str1 = s1+z;
  String str2 = s2+z;
  z = StrFind( str1, '.' ); if (z != -1) StrSLeft( str1, z );
  z = StrFind( str2, '.' ); if (z != -1) StrSLeft( str2, z );
  if ( StrCount( str1, "0123456789" ) == str1.len() && StrCount( str2, "0123456789" ) == str2.len() )
     return atoi(str1.asis()) - atoi(str2.asis());
   else
     return PathCmp( s1, s2 );
}

/////////////////////////////////////////////////////////////////////////////
//
//
//

int ficmp(int fn1, TF *f2)
{
TF *f1;
//TF *f2;

f1 = Files[fn1];
//f2 = Files[fn2];

char *fs1;
char *fs2;

int z = 0;

if (opt.TopDirs)
  {
  if ( f1->is_dir && !f2->is_dir) return -1;
  if (!f1->is_dir &&  f2->is_dir) return 1;
  }

if (opt.SortOrder == 'U') return 0;
switch (opt.SortOrder)
 {
 case 'N' : z = PathCmp(f1->name, f2->name);
            break;

 case 'M' : z = namenumcmp(f1->name, f2->name);
            break;

 case 'E' : fs1 = strrchr(f1->name, '.');
            fs2 = strrchr(f2->name, '.');
            if (fs1 == NULL) fs1 = f1->name + strlen(f1->name);
            if (fs2 == NULL) fs2 = f2->name + strlen(f2->name);
            z = PathCmp(fs1, fs2);
            if (z == 0) z = PathCmp(f1->name, f2->name);
            break;

 case 'S' : z = (f2->size  > f1->size)  - (f2->size  < f1->size);
            if (z == 0)
              z = PathCmp(f1->name, f2->name);
            else
              z = -z;
            break;

 case 'D' :
 case 'T' :
            if ( opt.fTimeType == 0 ) z = (f2->st.st_ctime > f1->st.st_ctime) - (f2->st.st_ctime < f1->st.st_ctime); else
            if ( opt.fTimeType == 1 ) z = (f2->st.st_mtime > f1->st.st_mtime) - (f2->st.st_mtime < f1->st.st_mtime); else
            if ( opt.fTimeType == 2 ) z = (f2->st.st_atime > f1->st.st_atime) - (f2->st.st_atime < f1->st.st_atime); else
                                      z = 0;
            if (z != 0) z = -z;
            if (z == 0) z = PathCmp(f1->name, f2->name);
            break;

 case 'A' : z = (f2->st.st_mode  > f1->st.st_mode)  - (f2->st.st_mode  < f1->st.st_mode);
            if (z == 0) z = PathCmp(f1->name, f2->name);
            break;

 case 'O' : z = (f2->st.st_uid  > f1->st.st_uid)  - (f2->st.st_uid  < f1->st.st_uid);
            if (z == 0) z = PathCmp(f1->name, f2->name);
            break;

 case 'G' : z = (f2->st.st_gid  > f1->st.st_gid)  - (f2->st.st_gid  < f1->st.st_gid);
            if (z == 0) z = PathCmp(f1->name, f2->name);
            break;

 case 'Y' : z = 0;
            break;
 default  : ASSERT( !"Non valid sort order (opt.SortOrder)" ); break;
 }

ASSERT( opt.Reversed == 'A' || opt.Reversed == 'D' );
if (z)
  {
  z = (z > 0) - (z < 0);
  if (opt.Reversed == 'D') return -z;
  }
return z;
}

/////////////////////////////////////////////////////////////////////////////
//
//
//

void Sort(int l, int r)
{
  int i;
  int j;
  int mid;
  TF *fi;
  TF *midf;
  i = l;
  j = r;
  mid = ((l+r) / 2);
  midf = Files[mid];

  do
    {
    while (ficmp(i,midf) == -1) i++;
    while (ficmp(j,midf) == 1) j--;
    if (i <= j)
//    if (i < j && ficmp( i, Files[j] ) == 1)
      {
      fi = Files[i];
      Files[i] = Files[j];
      Files[j] = fi;
      i++;
      j--;
      }
/*
    if (i <= j)
      {
      i++;
      j--;
      }
*/
    }
  while (i <= j);
  if (l < j) Sort(l, j);
  if (i < r) Sort(i, r);
}

/////////////////////////////////////////////////////////////////////////////
//
//
//

void ReSortFiles( int KeepArrangePos )
{
  if (!FilesCount) return;
  String str = Files[FLI]->name;
  Sort( 0, FilesCount - 1 );
  draw = 1;
  if ( KeepArrangePos && opt.KeepArrangePos && str != "" )
    {
    int z = 0;
    for (z = 0; z < FilesCount; z++)
      if ( str == Files[z]->name )
        {
        FGO(z);
        break;
        }
    };
}

/////////////////////////////////////////////////////////////////////////////
//
//
//

void SortFiles()
{
  int _ord;
  int _rev;
  mb.freeall();
  mb.add( "N Name" );
  mb.add( "M Name### (RTFM)" );
  mb.add( "E Extension" );
  mb.add( "S Size" );
  mb.add( "T Time" );
  mb.add( "D Time" );
  mb.add( "A Attr/mode" );
  mb.add( "O Owner" );
  mb.add( "G Group" );
  mb.add( "U Unsorted" );
  mb.add( "---" );
  mb.add( "V Move Entry" );
  if ( MenuBox( 50, 5, "Arrange" ) == -1 ) return;
  _ord = MenuBoxExitCh;

  if (_ord == 'V' )
    {
    FileEntryMove();
    return;
    }
  
  mb.freeall();
  mb.add( "A Ascending");
  mb.add( "D Descending" );
  if ( MenuBox( 50, 5, "Order" ) == -1 ) return;
  _rev = MenuBoxExitCh;

  opt.SortOrder = _ord;
  opt.Reversed = _rev;

  say1("");
  say2("Sorting...");
  ReSortFiles( 1 );
  say2("");
}

/////////////////////////////////////////////////////////////////////////////
//
//
//

void FileEntryMove()
{
  sprintf( sss, "MOVE/REORDER File entry: %s", Files[FLI]->name );
  say1( sss );
  say2( "Use Up/Down Arrows to reorder, ESC,ENTER when done." );
  int key = 0;
  while( key != 13 && key != 27 ) // enter or esc
    {
    int old = FLI;
    switch(key)
      {
      case KEY_UP    : __Up(); break;
      case KEY_DOWN  : __Dn(); break;
      }

    if ( old != FLI )
      {
      TF* fi = Files[old];
      Files[old] = Files[FLI];
      Files[FLI] = fi;
      ReDraw();
      }
    
    key = ConGetch();
    }
  say1( " " );
  say2( " " );
};

/////////////////////////////////////////////////////////////////////////////
//
// erase dir
//

int EraseMode; // 0 -- ok, otherwise abort
int EraseDir( const char *s )
{
  int res = 0;
  char newdname[MAX_PATH];

  DIR *dir;
  dirent *de;

  // directory should be writeable to erase files in it
  fsetattr_s( s, ATTR_WRITE_ON );

  dir = opendir( s );
  if (!dir)
    {
    sprintf( sss, "Cannot read dir: %s", s );
    say1( sss );
    DescribeErrno();
    ConGetch();
    return 1;
    }
  while( (de = readdir( dir )) )
    {
    if (strcmp( de->d_name, ".") == 0) continue;
    if (strcmp( de->d_name, "..") == 0) continue;
    sprintf( newdname, "%s/%s", s, de->d_name );

    String str = "ERASE: ";
    str += newdname;
    StrSLeft( str, MAXX );
    say1( str, cCYAN );
      
    struct stat st;
    struct stat lst;
    lstat( newdname, &lst );
    #ifdef _TARGET_GO32_
    dosstat( dir, &st );
    #else
    stat( newdname, &st );
    #endif
    int rres = 0;
    if (S_ISDIR(st.st_mode))
      {
      if (S_ISLNK(lst.st_mode))
        rres = unlink( newdname );
      else
        rres = EraseDir( newdname );
      }
    else
      {
      rres = unlink( newdname );
      }

    if (rres != 0)
      {
      DescribeErrno( "Cannot unlink: %s", newdname );
      if (MenuBox( "Error", "C Continue,A Abort" ) != 0)
        EraseMode = 1;
      res++;
      }
    if (BreakOp()) EraseMode = 1;
    if (EraseMode) break;
    }
  closedir( dir );

  res += (rmdir( s ) != 0);
  return res;
}

/////////////////////////////////////////////////////////////////////////////
//
// erase files
//

void EraseFiles(int one)
{
  char temp[255];

  if (SelCount == 0 && one == 0) one = 1;
  Beep();
  if (one == 0)
    strcpy(temp, "ERASE/unlink SELECTION? ( ENTER to confirm, other key to cancel ) ");
  else
    {
    if (opt.ZapROs == 0 && IsFileRO( Files[FLI]->name ))
      {
      sprintf( sss, "Cannot erase READ-ONLY file/dir: %s", Files[FLI]->name );
      say1( sss );
      Beep();
      ConGetch();
      return;
      }
    sprintf(temp, "ERASE/unlink `%s' ? ( ENTER to confirm, other key to cancel ) ", Files[FLI]->name);
    }

  say1(temp);
  char ch = ConGetch();
  say1("");
  if (ch != 13) return;

  int z;
  int res = 0;
  int err = 0;

    for(z = 0; z < FilesCount; z++ )
      if ((Files[z]->sel && one == 0) || (z == FLI && one == 1))
        {
        ASSERT(Files[z]);
        TF *fi = Files[z];

        if (opt.ZapROs == 0 && IsFileRO( Files[z]->name ))
          {
          sprintf( sss, "Cannot erase READ-ONLY file/dir: %s", Files[z]->name );
          say1( sss );
          say2( "ENTER to continue/skip this file, ESC to cancel" );
          Beep();
          int ch = 0;
          while( ch != 13 && ch != 27 ) ch = ConGetch();
          say1( "" );
          say2( "" );
          if (ch == 27) break;
          continue;
          }

        if (fi->is_dir)
          {
          if (fi->is_link)
            res = unlink(Files[z]->name);
          else
            {
            res = EraseDir(Files[z]->name);
            if (EraseMode) break;
            }
          }
        else
          res = unlink(Files[z]->name);

        if (res == 0)
          {
          delete Files[z];
          Files[z] = NULL;
          }
        else
          {
          DescribeErrno( "Cannot unlink: %s", fi->name );
          if (MenuBox( "Error", "C Continue,A Abort" ) != 0)
            break;
          err++;
          }
        }
  Pack(); // differs from Erase
  StatFS();
  ReDrawSta();
  // ReSortFiles(); mai nqma nuvda // differs from Erase
  if (err)
    {
    sprintf(sss, "ERASE errors: %d", err);
    say1(sss);
    DescribeErrno();
    }
  else
    say1("ERASE: ok.");
}

/////////////////////////////////////////////////////////////////////////////
//
//
//

void UpdateStats()
{
  FilesCount = 0;
  SelCount   = 0;
  SelSize    = 0;
  AllSize    = 0;
  int z      = 0;
  while( Files[z] != NULL )
    {
    SelCount += (Files[FilesCount]->sel != 0);
    if (Files[FilesCount]->sel)
      SelSize += Files[FilesCount]->size;
    AllSize  += Files[FilesCount]->size;
    FilesCount++;
    z++;
    }
  FINDEX.min = 0;
  FINDEX.max = FilesCount-1;
}

/////////////////////////////////////////////////////////////////////////////
//
//
//
void StatFS()
  {
  struct statfs stafs;
  statfs( ".", &stafs );
  FSFree  = (fsize_t)(stafs.f_bsize) * (opt.RealFreeSpace?stafs.f_bfree:stafs.f_bavail);
  FSTotal = (fsize_t)(stafs.f_bsize) * stafs.f_blocks;
  FSBSize = (fsize_t)(stafs.f_bsize);
  }

/////////////////////////////////////////////////////////////////////////////
//
//
//

