/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 *
 *
 * This routine scans through an array of strings, checking if
 * they exist as /proc/sys entries, and if so, writes the value
 * from the config file to them.
 *
 * Note, that entries may not exist due to old kernel, or support for that
 *  feature not being compiled into the current running kernel)
 */

//FIXME:
// To do - The strings shouldn't need /proc/sys in them.
// Instead just copy the non-const part into an array
// prefixed by /proc/sys

void Optimise_proc(void)
{
	const char *proc_names[] = {
		"/proc/sys/net/ipv4/tcp_syncookies",
		"/proc/sys/fs/file-max",
		"/proc/sys/vm/freepages",
		"/proc/sys/net/ipv4/tcp_fin_timeout",		//30
		"/proc/sys/net/ipv4/tcp_keepalive_time",	//1800
		"/proc/sys/net/ipv4/tcp_timestamps",
		"/proc/sys/net/ipv4/tcp_window_scaling",
		"/proc/sys/net/ipv4/tcp_sack",
		"/proc/sys/net/ipv4/icmp_ignore_bogus_error_responses",
		0}; 

	const char **name_ptr;
	char *option;

	FILE *file=0;

	name_ptr = proc_names;

	while (*name_ptr) {
		/* Is this tweak in the config file ? */
		if (find_PROC_tag(*name_ptr, &option)==TRUE) {

			/* Does the /proc/sys entry exist? */
			if (file=fopen (*name_ptr, "w")) {
				fprintf(file, "%s\n", option);
				fclose (file);
			}
		}
		name_ptr++;
	}
}
