/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "version.h"
#include "pciutils.h"

/* Communication with libpci */
struct pci_access *pacc;
struct pci_dev *dev;

#include "GUI/tweak.h"
void write_tweaks (FILE *savehandle, unsigned int numtweaks, Tweaks_t *tweaks, struct pci_dev *current);
void init_tweaks (unsigned int numtweaks, Tweaks_t *tweaks, struct pci_dev *current);

#include "GUI/create-GUI.c"
#include "GUI/save.c"

/*
 * main
 *
 * Program begins here
 */

int main (int argc, char *argv[])
{
	GtkWidget *window;

	if (iopl(3)) {
		fprintf(stderr, "Powertweak-config can only be run by root.\n");
		exit(EXIT_FAILURE);
	} else {

		pacc = pci_alloc();
		pci_init(pacc);
		pacc->error = die;
		pci_scan_bus(pacc);

		gtk_init (&argc, &argv);
		window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title (GTK_WINDOW (window), "Powertweak-Linux.");
		gtk_widget_set_usize (window, WindowWidth, WindowHeight);

		gtk_signal_connect (GTK_OBJECT (window), "delete_event",
							GTK_SIGNAL_FUNC (quit_app), NULL);

		init_configfile();
		CreateGadgets(window);
		gtk_widget_show (window);

		gtk_main ();

		pci_cleanup(pacc);

		exit (0);
	}
}
