/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#define PCI_VENDOR_ID_DEC	0x1011
#define PCI_VENDOR_ID_UMC	0x1060
#define PCI_VENDOR_ID_VIA	0x1106
#define PCI_VENDOR_ID_Intel	0x8086

#include "tune.c"
#include "DEC/DECchip_21050.c"
#include "Intel/824xx.c"
#include "Intel/8243x.c"
#include "Intel/82437.c"
#include "Intel/82439.c"
#include "Intel/82443EX_LX.c"
#include "Intel/82443BX_ZX.c"
#include "UMC/8891A.c"
#include "VIA/82C586_0.c"
#include "VIA/82C586_1.c"
#include "VIA/82C597_0.c"
#include "VIA/82C597_1.c"
#include "VIA/82C598_1.c"

/*
 Optimise_PCI()
 This gets called from main() if PCI optimisation is enabled.
 */

void Optimise_PCI(void)
{
	struct pci_dev *dev;

	typedef void (*device_handler)(struct pci_dev *);

	struct devinfo {
		unsigned short vendor, device;
		device_handler handler;
	};

	struct devinfo known_devlist[] = {
		{ PCI_VENDOR_ID_DEC,	PCI_DEVICE_ID_DEC_21050,		tune_DEC_21050 },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82424,		tune_Intel_824xx },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82430,		tune_Intel_824xx },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82434,		tune_Intel_824xx },
		{ PCI_VENDOR_ID_INTEL,  PCI_DEVICE_ID_Intel_82437VX,	tune_Intel_82437VX },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82437FX,	tune_Intel_8243x },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82439HX,	tune_Intel_8243x },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82439TX,	tune_Intel_82439TX },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82443EX_LX,	tune_Intel_82443EX_LX },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82443BX_ZX,	tune_Intel_82443BX_ZX },
		{ PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82443BX_ZX_NOAGP,	tune_Intel_82443BX_ZX },
		{ PCI_VENDOR_ID_VIA,	PCI_DEVICE_ID_VIA_586_0, 		tune_VIA_586_0 },
		{ PCI_VENDOR_ID_VIA,	PCI_DEVICE_ID_VIA_586_1, 		tune_VIA_586_1 },
		{ PCI_VENDOR_ID_VIA,	PCI_DEVICE_ID_VIA_597_0,		tune_VIA_597_0 },
		{ PCI_VENDOR_ID_VIA,	PCI_DEVICE_ID_VIA_597_1,		tune_VIA_597_1 },
		{ PCI_VENDOR_ID_VIA,	PCI_DEVICE_ID_VIA_598_1,		tune_VIA_597_1 },
		{ PCI_VENDOR_ID_UMC,	PCI_DEVICE_ID_UMC_8891A,		tune_UMC_8891A },
		{ 0, 0, 0 }
	};

	struct devinfo *d = known_devlist;
	char namebuf[128];

	pci_scan_bus(pacc);

	/*
	 * This next bit of code is remarkably simple, but caused so many
	 * headaches for gcc 2.95.1, and late egcs snapshots.
	 * It took considerable rewriting to get this to work flawlessly. - DJ
	 */

	while (d->vendor) {
		dev = pacc->devices;

		/* Scan through the PCI list. */
		while (dev) {

			/* Do we have this device ? */
			if ((d->vendor == dev->vendor_id) && (d->device == dev->device_id)) {
				if (open_log_file(&logfile)==TRUE) {
					fprintf(logfile, "\tTuning device: [%.4x:%.4x] %s\n",
						dev->vendor_id, dev->device_id,
						pci_lookup_name(pacc, namebuf, sizeof(namebuf),
						PCI_LOOKUP_VENDOR|PCI_LOOKUP_DEVICE,
						dev->vendor_id, dev->device_id, 0, 0));
					close_log_file(&logfile);
				}
				d->handler(dev);
				goto next_device;
			}
			dev = dev->next;
		}
next_device:
		d++;
	}
}
