/*
 * Hardware tuning for the Intel 82443LX Host bridge
 */

#include "82443_LX.h"

#define Intel_82443LX_TWEAKSIZE (sizeof(Intel_82443LX_Tweaks)/sizeof(Tweaks_t))-1

unsigned int getnumtweaks_Intel_82443LX(struct pci_dev *current_dev)
{
	return Intel_82443LX_TWEAKSIZE;
}

void init_Intel_82443LX(struct pci_dev *current_dev)
{
	init_tweaks(Intel_82443LX_TWEAKSIZE, Intel_82443LX_Tweaks, current_dev);
}

void tune_Intel_82443LX(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = Intel_82443LX_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton(table, Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_Intel_82443LX(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, Intel_82443LX_TWEAKSIZE, Intel_82443LX_Tweaks, current_dev);
}
