/*
 * Hardware tuning for the Intel 82443BX Host bridge
 */

#include "82443_BX.h"

#define Intel_82443BX_TWEAKSIZE sizeof(Intel_82443BX_Tweaks)/sizeof(Tweaks_t)-1

unsigned int getnumtweaks_Intel_82443BX(struct pci_dev *current_dev)
{
	return Intel_82443BX_TWEAKSIZE;
}

void init_Intel_82443BX(struct pci_dev *current_dev)
{
	init_tweaks(Intel_82443BX_TWEAKSIZE, Intel_82443BX_Tweaks, current_dev);
}

void tune_Intel_82443BX(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = Intel_82443BX_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton(table, Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_Intel_82443BX(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, Intel_82443BX_TWEAKSIZE, Intel_82443BX_Tweaks, current_dev);
}
