/*
    libparted
    Copyright (C) 1998-2000  Andrew Clausen  <clausen@gnu.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "fat.h"
#include "fatio.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>

int
fat_read_clusters (PedFileSystem* fs, char *buf, FatCluster cluster,
		   FatCluster count)
{
	FatSpecific*	fs_info = FAT_SPECIFIC (fs);

	if (cluster >= fs_info->cluster_count + 2
	    || cluster + count - 1 >= fs_info->cluster_count + 2) {
		ped_exception_throw (PED_EXCEPTION_FATAL,
				     PED_EXCEPTION_CANCEL,
                   _("fat_read_clusters: clusters %ld-%ld outside filesystem"),
                       cluster, cluster + count);
		return 0;
	}

	return ped_geometry_read (fs->geom, buf,
				  fs_info->cluster_offset
					+ cluster * fs_info->cluster_sectors,
				  count * fs_info->cluster_sectors);
}

int
fat_read_cluster (PedFileSystem* fs, char *buf, FatCluster cluster)
{
	return fat_read_clusters (fs, buf, cluster, 1);
}

int
fat_write_clusters (PedFileSystem* fs, char *buf, FatCluster cluster,
		    FatCluster count)
{
	FatSpecific*	fs_info = FAT_SPECIFIC (fs);

	if (cluster >= fs_info->cluster_count + 2
	    || cluster + count - 1 >= fs_info->cluster_count + 2) {
		ped_exception_throw (PED_EXCEPTION_FATAL,
				     PED_EXCEPTION_CANCEL,
                   _("fat_write_clusters: clusters %ld-%ld outside filesystem"),
                       cluster, cluster + count);
		return 0;
	}

	return ped_geometry_write (fs->geom, buf,
				   fs_info->cluster_offset
					+ cluster * fs_info->cluster_sectors,
				   count * fs_info->cluster_sectors);
}

int
fat_write_cluster (PedFileSystem* fs, char *buf, FatCluster cluster)
{
	return fat_write_clusters (fs, buf, cluster, 1);
}

int
fat_write_sync_clusters (PedFileSystem* fs, char *buf, FatCluster cluster,
			 FatCluster count)
{
	if (!fat_write_clusters (fs, buf, cluster, count))
		return 0;
	if (!ped_geometry_sync (fs->geom))
		return 0;
	return 1;
}

int
fat_write_sync_cluster (PedFileSystem* fs, char *buf, FatCluster cluster)
{
	if (!fat_write_cluster (fs, buf, cluster))
		return 0;
	if (!ped_geometry_sync (fs->geom))
		return 0;
	return 1;
}

