#! /bin/sh
#
# rc.6		This file is executed by init when it goes into runlevel
#		0 (halt) or runlevel 6 (reboot). It kills all processes,
#		unmounts file systems and then either halts or reboots.
#
# Version:	@(#)/etc/rc.d/rc.6	1.50	1994-01-15
#
# Author:	Miquel van Smoorenburg <miquels@drinkel.nl.mugnet.org>
# Modified by:  Patrick J. Volkerding, <volkerdi@ftp.cdrom.com>
#

  # Set the path.
  PATH=/sbin:/etc:/bin:/usr/bin

  # Set linefeed mode to avoid staircase effect.
  stty onlcr

  echo "Running shutdown script $0:"

  # Find out how we were called.
  case "$0" in
	*0)
		message="The system is halted."
		command="halt"
		;;
	*6)
		message="Rebooting."
		command=reboot
		;;
	*)
		echo "$0: call me as \"rc.0\" or \"rc.6\" please!"
		exit 1
		;;
  esac

  # Kill all processes.
  # INIT is supposed to handle this entirely now, but this didn't always
  # work correctly without this second pass at killing off the processes.
  # Since INIT already notified the user that processes were being killed,
  # we'll avoid echoing this info this time around.
  if [ "$1" != "fast" ]; then # shutdown did not already kill all processes
    killall5 -15 
    killall5 -9
  fi

  # Try to turn off quota and accounting.
  if [ -x /usr/sbin/quotaoff ]
  then
	echo "Turning off quota."
	/usr/sbin/quotaoff -a
  fi
  if [ -x /sbin/accton ]
  then
	echo "Turning off accounting."
	/sbin/accton
  fi

  # Before unmounting file systems write a reboot or halt record to wtmp.
  $command -w

  # Save localtime
  [ -e /usr/lib/zoneinfo/localtime ] && cp /usr/lib/zoneinfo/localtime /etc

  # Asynchronously unmount any remote filesystems:
  echo "Unmounting remote filesystems."
  umount -a -tnfs &

  # Turn off swap, then unmount local file systems.
  echo "Turning off swap."
  swapoff -a
  echo "Unmounting local file systems."
  umount -a -tnonfs
  # Don't remount UMSDOS root volumes:
  if [ ! "`mount | head -1 | cut -d ' ' -f 5`" = "umsdos" ]; then
    mount -n -o remount,ro /
  fi

#  # See if this is a powerfail situation.
#  if [ -f /etc/power_is_failing ]; then
#    echo "Turning off UPS, bye."
#    /sbin/powerd -q
#    exit 1
#  fi

  # See if this is a powerfail situation.
  if [ -f /etc/powerfail ]; then
    echo "APCUPSD to the Rescue!"
    echo
    /sbin/powersc KILL
    echo
    sleep 120
    exit 1
  fi

  # Now halt or reboot.
  echo "$message"
  [ ! -f /etc/fastboot ] && echo "On the next boot fsck will be FORCED."
  $command -f

