/******************************************************************************

  SUFARYڵץ af
    Version 0.0.2 981109

   USAGE:
     af KEYWORD FILE1
     af '' FILE1

    FILE1.ary FILE1.did ɬ

   (KEYWORD)  '' ꤹȡɸϤ饭
     ϤƸԤʤޤ

 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "sufary.h"

typedef struct _doc_info {
  long start;
  long size;
  long no;
  int freq;
} doc_info;

int do_kensaku(SUFARY *ary, DID *did, char *key);
int search_and_check(SUFARY *ary, DID *d, char *key, unsigned char var);
int search_and_print(SUFARY *ary, DID *d, char *key, unsigned char);
void _parse_keys(char*);
void usage(void);

static int mycomp(doc_info *i,doc_info *j){return(i->no - j->no);}
static int mycomp2(doc_info *i,doc_info *j){return(j->freq - i->freq);}

unsigned char *did_check;

char nkeys[100][80]; /* nkeys = NOTѥ(Ex: ^ؤؤ) */
char keys[100][80];  /* keys  = Ԥäѥ(Ex: ۤۤ) */
int num_of_nkeys; int num_of_keys;
/********************************************************************* 
  Ex: ^ؤؤ&ۤۤ&Ҥ
   nkeys[0] = "ؤؤ", nom_of_nkeys = 1
   keys[0] = "ۤۤ", keys[1] = "Ҥ", nom_of_nkeys = 2
  ν parse_keys("^ؤؤ&ۤۤ&Ҥ") ǹԤ롣
  ***************************************************************************/

int display_all_flag = 1;
int display_char_num = 316;
/********************************************************************* 
  display_all_flag  1 ʤ顢Ƥɽ롣
  0 ʤ鵭Ƭ display_char_num ʸɽ롣
  ***************************************************************************/

main(int argc, char *argv[])
{
  SUFARY *ary;
  DID *did;
  char didfile[1000];

  while (argc > 1){
    if (argv[1][0] == '-')
      switch (argv[1][1]){
      case 's': /* åϤʤ */
	display_all_flag = 0;
	if (argc == 2){usage();exit(1);}
	display_char_num = atoi(argv[2]);
        argc--; argv++;
        break;
      default : /* 顼 */
        fprintf(stderr, "%c: ̵ʥץǤ\n", argv[1][1]);
        usage();
        exit(1);
      }
    else break;
    argc--; argv++;
  }

  if(argc < 2){usage(); exit(1);} /* ­ʤ */

  /** ե򳫤 **/
  if ((ary = sa_openfiles(argv[2],NULL)) == NULL) exit(1);
  sprintf(didfile,"%s.did",argv[2]);
  if ((did = sa_opendid(didfile)) == NULL) exit(1);

  /** ̥å **/
  while(1){ /* 990210 ݤǤޤǴĥ */
    did_check = (char *)malloc(sa_did_size(did));
    if(did_check != NULL) break;
    sleep(1);
  }

  (void)memset(did_check, 0, sa_did_size(did));

  if(argv[1][0] == '\0'){ /*** ɸϤ饭 ***/
    char cmd[1000];
    while(fgets(cmd, (int)sizeof(cmd), stdin)){
      cmd[strlen(cmd)-1] = '\0'; /* Ϥ줿ɤβ٤ */
      do_kensaku(ary, did, cmd);
      (void)memset(did_check, 0, sa_did_size(did));
    }
  } else do_kensaku(ary, did, argv[1]); /*** (argv[1]) ***/
    
  /** եĤ **/
  sa_closefiles(ary);
  sa_closedid(did);
}



/************************************************************
  Ϣθ
 ************************************************************/
int do_kensaku(SUFARY *ary, DID *did, char *key){
  /* [] å bit ǤεݤȽǤ롣
     å bit ȬġʳƵȤˡˡǲ bit  1 ʤ 
     NOTɤޤޤƤꡢ̤ȤŬǤ롣¾ bit 
     ̤ΥɤޤޤƤ뤫ݤɽ*/

  int i; unsigned char checker = 0x01;
  num_of_nkeys = 0; num_of_keys = 0;

  if(parse_keys(key) == 0){
    printf("KEYWORD FORMAT ERROR\n");
    return 0;
  }

  for(i = 0; i < num_of_nkeys; i++) search_and_check(ary, did, nkeys[i], 0x01);
  /* [] ޤNOTɤޤޤ뵭Υ bit ΩƤ롣*/

  for(i = 0; i < num_of_keys-1; i++){
    checker *= 2;
    if(search_and_check(ary, did, keys[i], checker) == 0) return 0;
  }
  /* [] 줫̥ɤޤޤ뵭 OK bit ΩƤ롣*/

  return search_and_print(ary, did, keys[num_of_keys-1], checker*2-2);
  /* [] Ǹ̥ɤǤθ̵ bit å뤳Ȥ
     ꡢƤξ̤ʬ */
}


/************************************************************
  ʸʣΥʬ
  ޤä 1Ԥ 0 ֤
 ************************************************************/
int parse_keys(char *kstr){
  char *start = kstr;
  int i, keylen = strlen(kstr);
  for(i = 0; i < keylen-1; i++)
    if(strncmp(kstr+i,"&&",2) == 0) return 0;
  if(kstr[keylen-1] == '&') return 0;
  for(i = 0; i < keylen; i++)
    if(kstr[i] == '&'){
      kstr[i] = '\0';
      _parse_keys(start);
      start = kstr+i+1;
    }
  if(*start != '\0') _parse_keys(start);
  if(num_of_keys == 0) return 0;
  return 1;
} 

void _parse_keys(char *start){
  if(*start == '^'){
    strcpy(nkeys[num_of_nkeys], start+1);
    num_of_nkeys++;
  } else {
    strcpy(keys[num_of_keys], start);
    num_of_keys++;
  }
}


/************************************************************
  Ʒ̤å
  ̸ǸĤʤä 0 ¾ξ 1 ֤
 ************************************************************/
int search_and_check(SUFARY *ary, DID *d, char *key, unsigned char var)
{
  long ai, sar, sal, no;
  sa_reset(ary);
  if (sa_sel(ary, key) == CONT){
    sar = sa_right(ary); sal = sa_left(ary);
    for (ai = sal; ai <= sar; ai++){
      sa_didsearch(d, sa_aryidx2txtidx(ary, ai));
      no = sa_doc_no(d);
      if(no != -1) did_check[no] |= var;
    }
    return 1;
  } else {
    if(var == 0x01) return 1;
    printf("NOT FOUND [%s]\n", key);
    return 0;
  }
}


/************************************************************
  Ʒ̤ɽ
  Ĥʤä 0 򡢸Ĥä 1 ֤
 ************************************************************/
int search_and_print(SUFARY *ary, DID *d, char *key, unsigned char sikii)
{
  long i, ai, sar, sal;
  long *doc_start_array, *doc_size_array;
  int how_many = 0;
  sa_reset(ary);
  if (sa_sel(ary, key) == CONT){
    long no;
    sar = sa_right(ary); sal = sa_left(ary);

    while(1){ /* 990210 ݤǤޤǴĥ */
      doc_start_array = (long *)malloc(sizeof(long)*(sar-sal+1));
      doc_size_array = (long *)malloc(sizeof(long)*(sar-sal+1));
      if(doc_start_array != NULL && doc_size_array != NULL) break;
      sleep(1);
    }

    for (ai = sal; ai <= sar; ai++){
      sa_didsearch(d, sa_aryidx2txtidx(ary, ai));
      no = sa_doc_no(d);
      if(no == -1) continue;
      if(did_check[no] == sikii ){
	did_check[no] = 0x01; /* ϺѤ */
	doc_start_array[how_many] = sa_doc_start(d);
	doc_size_array[how_many] = sa_doc_size(d);
	how_many++;
      }
    }

    printf("FOUND %d\n",how_many);
    if(display_char_num <= 0) return; /* ̵ɽ */

    for(i = 0; i < how_many; i++){
	char *art;
	if(display_all_flag == 1){
	  art = sa_getstr(ary, doc_start_array[i], doc_size_array[i]);
	  printf("%s\n", art);
	}else{
	  int j, ctr8 = 0;
	  art = sa_getstr(ary, doc_start_array[i], display_char_num);
	  for(j = display_char_num-1; j >= 0; j--)
	    if((unsigned char)art[j] & 0x80) ctr8++;
	    else break;
	  if(ctr8 % 2 == 1) art[display_char_num-1] = '%';
	  /*sa_mojibakebousi(art);*/
	  printf("---\n%s\n", art);
	}
	free(art);
    }
    return 1;
  } else {
    printf("NOT FOUND [%s]\n", key);
    return 0;
  }
}


/******************
  usage --- Ȥ
 ******************/
void usage(void){
  fprintf(stderr, "\n"
          "af --- Article Finder : ץ\n\n"
	  "Version 0.0.3 980210\n\n"
          "USAGE\n"
          "  af [ -s NUM ] KEYWORD FILE_NAME\n"
          "\n"
          "OPTION\n"
          "  -s NUM  : ̵Ƭ NUM ʸɽ\n"
          "            NUM = 0 ΤȤϸ̵Τߤɽ\n"
          "\n"
          "TOPIC\n"
	  " * KEYWORD  '' ꤹɸϤ饭\n"
	  " * ɤν\n"
	  "    AND: ɤ & ǤĤʤ\n"
	  "    NOT: ɤ ^ Ĥ\n"
	  "    () ^&&ƥ\n"
          "\n"
          );
}
