/*
 * Misc header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_MISC_H__
#define __GDIFF_MISC_H__

#include <stdio.h>/* for FILE */

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */


/* Contant numbers */
typedef enum {
	REGULARFILE,
	DIRECTORY,
	OTHERFILE,
} FileType;
	

/* Global function declarations */
/* misc.c */
extern inline const char* skip_n_lines(const char *ptr, int nl, int lenb);
extern FileType check_filetype(const char *fname);
extern int get_num_chars(const char *src, int lenb);
extern int calc_number_places(int n);
extern void get_file_name(char *fname, const char *fpath);
extern void close_allfd_except_std(void);
extern void def_signal_handler(int sig);

/* spawn.c */
extern FILE* spawn_diff(char *prog, char *args, char *path1, char *path2);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_MISC_H__ */
