
#include "file_exceps.hh"

namespace autil {

  CantReadFile::CantReadFile(const string & f)
    : FileException(f, "Sorry, I can't read the file \"" + f + "\".")
  {}

  CantWriteFile::CantWriteFile(const string & f)
    : FileException(f, "Sorry, I can't write to \"" + f + "\".")
  {}

  BadFileFormat::BadFileFormat(const string & f, const string & w)
    : FileException(f, w.size() == 0
		    ? "The file \"" + f + "\" is not in the proper format."
		    : f + ": " + w)
  {}
}

