# menu.tcl -- Make TkDVI menu bars.
# Copyright  1999 Anselm Lingnau.
# See file COPYING for conditions on use and distribution.
# $Id: menu.tcl,v 1.1.1.1 1999/06/10 12:36:50 lingnau Exp $
#
# This code borrows heavily from Brent Welch's book. Thanks Brent!

package provide tkdvi::menu 1.0

namespace eval tkdvi::menu {
    proc menubar {name {top {}}} {
	set m [menu $name]
	foreach b [option get $m menulist {}] {
	    if [catch {menu $m.$b}] {
		menu $m.$b -font fixed
	    }
	    set label [option get $m.$b text {}]
	    set cmd [list $m add cascade -label $label -menu $m.$b]
	    if [catch $cmd t] {
		eval $cmd {-font fixed}
	    }
	    define $m.$b $top
	}
    }
    proc define {menu {top {}}} {
	foreach e [option get $menu entrylist {}] {
	    if {$e == "-"} {
		$menu add separator
		continue
	    }
	    set l [option get $menu l_$e {}]
	    set c [option get $menu c_$e {}]
	    set v [option get $menu v_$e {}]
	    regsub -all {%T} $c $top c
	    regsub -all {%M} $c $menu c
	    regsub -all {%T} $v $top v
	    regsub -all {%M} $v $menu v
	    switch -- [option get $menu t_$e {}] {
		check {
		    $menu add checkbutton -label $l -command $c -variable $v
		}
		radio {
		    $menu add radiobutton -label $l -variable $v -value $e
		}
		cascade {
		    set sub [option get $menu m_$e {}]
		    set post [option get $menu p_$e {}]
		    if {$post != {}} {
			regsub -all {%T} $post $top post
			regsub -all {%S} $post $menu.$sub post
			set submenu [menu $menu.$sub -postcommand $post]
			$menu add cascade -label $l -menu $submenu
		    } elseif {[string length $sub] != 0} {
			set submenu [menu $menu.$sub]
			regsub -all {%S} $c $submenu c
			$menu add cascade -label $l -command $c -menu $submenu
			define $submenu $top
		    }
		}
		default {
		    $menu add command -label $l -command $c
		}
	    }
	}
    }
}
