# Copyright (C) 1998, DGA - part of the Transcriber program
# distributed under the GNU General Public License (see COPYING file)

#package require snack

#################################################################

# Play requested audio file
#   begin/end : segment to play (in seconds); defaults to all signal
#   script :    callback after non-interrupted playback

proc PlayRange {{begin 0} {end 0} {script {}}} {
   global v

   PauseAudio

   set wavename $v(sig,name)
   if {$wavename == ""} return

   if {[info commands player] == ""} {
      sound player
   }
   if {!$v(sig,remote)} {
      # if possible, keep previously open sound file
      if {[player cget -file] != $wavename} {
	 player conf -file $wavename -channels $v(sig,channels) -frequency $v(sig,rate) -skiphead $v(sig,header) -guessproperties 1
      }
      # Apply multiplying factor to frequency - does not work with current
      # snack version.
      player conf -frequency [expr int([$v(sig,cmd) cget -frequency]*$v(playbackSpeed))]
      set rate [$v(sig,cmd) cget -frequency]
      player play -start [expr int($begin*$rate)] -end [expr int($end*$rate)]
   } else {
      set snd [OpenSound $wavename]
      set nbch [$snd cget -channels]
      set rate [$snd cget -frequency]
      set chan [$snd dump -start [expr int($begin*$rate)] -end [expr int($end*$rate)]]
      player conf -channel $chan -channels $nbch -frequency $rate -format lin16
      player play -command [list close $chan]
   }
   CursorStart $begin $end
   IsPlaying 1
   
   # Callback after playback (rewind cursor by default)
   if {$script == {}} {
      set script "SetCursor $begin"
   }
   set v(play,after) $script
}

# Stop current play and freeze cursor
proc PauseAudio {} {
   global v
   if {[info commands player] != ""} {
      catch {close [player conf -channel]}
      player stop
   }
   CursorStop
   IsPlaying 0
}

#################################################################
# Automatic cursor management

# called from: PlayRange
proc CursorStart {pos max} {
   global v

   set v(curs,pos) $pos
   set v(curs,start) $pos
   set v(curs,max) $max
   # Ask for cursor events every 20 ms
   CursorEvent 20
   # Permit fast forward/backward
   catch {unset v(play,no-fast)}
}

# called from: PauseAudio
proc CursorStop {} {
   global v

   if [info exists v(curs,event)] {
      after cancel $v(curs,event)
      unset v(curs,event)
   }
}

# Update cursor position in waveform widget
proc CursorEvent {inc} {
   global v

   set pos [expr $v(curs,start)+[audio elapsedTime]*$v(playbackSpeed)]
   if {$pos>$v(curs,max) || ![audio active]} {
      PauseAudio
      # Command to be launched after signal playback (rewind by default)
      eval $v(play,after)
      return
   }
   foreach win $v(wavfm,list) {
      set margin [expr 0.05 * $v($win,size)]
      if {($pos<$v($win,left))||
	  ($pos>$v($win,right)-$margin && $v(curs,max)>$v($win,right))} {
	 set v($win,left) [expr $pos-$margin]
	 SynchroWidgets $win
      }
   }
   SetCursor $pos
   set v(curs,event) [after $inc [list CursorEvent $inc]]
}

#################################################################

# Stop playing and reset cursor to beginning of selection or file
proc StopAndRewind {} {
   global v

   PauseAudio
   if [GetSelection beg end] {
      SetCursor $beg hide
   } else {
      SetCursor $v(sig,min) hide
   }
}

# Start new play at cursor pos 
proc Play {} {
   global v

   if ![GetSelection beg end] {
      DisplayMessage ""
   }
   set pos [GetCursor]
   if {($pos<$beg) || ($pos>=$end)} {
      set pos $beg
   }
   PlayRange $pos $end
}

proc IsPlaying {{state {}}} {
   global v

   if {$state != ""} {
      if {$state} {
	 $v(tk,play) config -state disabled
	 $v(tk,stop) config -state active
      } else {
	 $v(tk,play) config -state active
	 $v(tk,stop) config -state disabled
      }
      set v(play,state) $state
   } else {
      if ![info exists v(play,state)] {
	 set v(play,state) 0
      }
      return $v(play,state)
   }
}

#################################################################

# Stop current play, keeping current pos
# or restart play at previous pos
proc PlayOrPause {} {
   global v

   if [info exists v(curs,event)] {
      PauseAudio
   } else {
      Play
   } 
}

proc PlayFromBegin {} {
   global v

   StopAndRewind
   Play
}

proc PlayCurrentSegmt {} {
   global v

   if [info exists v(segmt,curr)] {
      set beg [GetSegmtField seg0 $v(segmt,curr) -begin]
      set end [GetSegmtField seg0 $v(segmt,curr) -end]
      SetSelection $beg $beg
      PlayRange $beg $end
   } else {
      PlayFromBegin
   }
}

proc PlayBefore {{dur 1.0}} {
   SetCursor [expr [GetCursor]-$dur]
   Play
}

#################################################################
# continuous play with pauses or beeps at segment boundaries

proc PlayWithPauses {} {
   global v

   if [info exists v(segmt,curr)] {
      set n $v(segmt,curr)
      set beg [GetSegmtField seg0 $n -begin]
      set end [GetSegmtField seg0 $n -end]
      incr n
      if {$n < [GetSegmtNb seg0]} {
	 if {$v(play,beep) != ""} {
	    set script "SetCurrentSegment $n; PlayBeep"
	 } else {
	    set script "SetCurrentSegment $n; [list after [expr int(1000*$v(play,delay))] PlayWithPauses]"
	 }
      } else {
	 set script ""
      }
      PlayRange $beg $end $script
   } else {
      PlayFromBegin
   }
}

proc PlayBeep {} {
   global v

   catch {sound beeper}
   beeper conf -file $v(play,beep)
   beeper play -command "IsPlaying 0; after 0 PlayWithPauses"
   IsPlaying 1
}

#################################################################
# Play a little part of signal before and after cursor position

proc PlayAround {{len 1.0} {delay 0.5}} {
   global v

   set pos [GetCursor]
   SetCursor [expr $pos-$len]; set left [GetCursor]
   SetSelection $left $pos
   set script [list after [expr int(1000*$delay)] PlayAround2 $len $pos]
   PlayRange $left $pos $script
}

proc PlayAround2 {len pos} {
   global v

   SetCursor [expr $pos+$len]; set right [GetCursor]
   SetSelection $pos $right
   set script [list PlayAround3 $pos]
   PlayRange $pos $right $script
}

proc PlayAround3 {pos} {
   global v
   SetSelection $pos $pos
}

#################################################################
# Fast forward/backward (depending on direction)
# move with 1/2s step and restart playing
proc PlayForward {dir} {
   global v

   set play [IsPlaying]
   if $play {
      if [info exists v(play,no-fast)] return
      set v(play,no-fast) 1
   }

   set pos [expr [GetCursor]+$dir*0.5]
   SetCursor $pos
   #ViewSelection $pos $pos
   if $play Play
}

# Fwd/bwd from button press with auto-repeat
proc BeginPlayForward {dir} {
   global v

   catch {after cancel $v(curs,fast)}
   set v(curs,fast) [after 200 [list BeginPlayForward $dir]]
   PlayForward $dir
}

# button release : unregister event
proc EndPlayForward {} {
   global v

   catch {after cancel $v(curs,fast)}
}
