#include <snack.h>
#include <tk.h>

/* 
 * This part taken from SNACK
 * Copyright (C) 1997-98 Kare Sjolander <kare@speech.kth.se>
 *
 */

#if defined(__WIN32__)
#  define WIN32_LEAN_AND_MEAN
#  include <windows.h>
#  undef WIN32_LEAN_AND_MEAN
#  define EXPORT(a,b) __declspec(dllexport) a b
BOOL APIENTRY
DllMain(HINSTANCE hInst, DWORD reason, LPVOID reserved)
{
  return TRUE;
}
#else
#  define EXPORT(a,b) a b
#endif


int AxisCmd( ClientData clientData, Tcl_Interp *interp,
	      int argc, char *argv[]);
int SegmtCmd( ClientData clientData, Tcl_Interp *interp,
	      int argc, char *argv[]);
int WavfmCmd( ClientData clientData, Tcl_Interp *interp,
	      int argc, char *argv[]);

extern int CentiCmd(ClientData cdata, Tcl_Interp *interp, int objc,
            Tcl_Obj *CONST objv[]);
extern int ShapeCmd(ClientData cdata, Tcl_Interp *interp, int objc,
            Tcl_Obj *CONST objv[]);
extern int GetCmd(ClientData cdata, Tcl_Interp *interp, int objc,
            Tcl_Obj *CONST objv[]);
extern int OrderCmd(ClientData cdata, Tcl_Interp *interp, int objc,
            Tcl_Obj *CONST objv[]);

/* Called by "load trans" */
extern EXPORT(int,Trans_Init) _ANSI_ARGS_(( Tcl_Interp *interp))
{
   int res = Tcl_PkgProvide( interp, "trans", "1.4");
   if (res != TCL_OK) return res;

   /* Tk widgets for waveform and segmentation display */
   Tcl_CreateCommand( interp, "axis", AxisCmd,
		      (ClientData)Tk_MainWindow(interp),
		      (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateCommand( interp, "segmt", SegmtCmd,
		      (ClientData)Tk_MainWindow(interp),
		      (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateCommand( interp, "wavfm", WavfmCmd,
		      (ClientData)Tk_MainWindow(interp),
		      (Tcl_CmdDeleteProc *)NULL);

   /* New Snack sound commands */
   Snack_AddSubCmd(SNACK_SOUND_CMD, "centi", (Snack_CmdProc *)CentiCmd, NULL);
   Snack_AddSubCmd(SNACK_SOUND_CMD, "shape", (Snack_CmdProc *)ShapeCmd, NULL);
   Snack_AddSubCmd(SNACK_SOUND_CMD, "get",   (Snack_CmdProc *)GetCmd,   NULL);
   Snack_AddSubCmd(SNACK_SOUND_CMD, "order", (Snack_CmdProc *)OrderCmd, NULL);

   return TCL_OK;
}

EXPORT(int,Trans_SafeInit)(Tcl_Interp *interp)
{
  return Trans_Init(interp);
}
