#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <stdio.h>
#include <stdlib.h>
#include "Panel.h"
#include "Qstat.h"
#include "Sindicator.h"
#include "Time.h"
#include "xppxpm.h"
#include "pixmap/mini-panel.xpm"
#include "pixmap/mini-panel.msk"
#include "pixmap16/mini-panel.xpm"
#include "pixmap16/mini-panel.msk"

struct panel_pixmap {
	char** panel;
	char*  mask;
	int    width;
	int    height;
} pixdata[] = {
{
	mini_panel_xpm,
	mask_bits,
	mask_width,
	mask_height,
}, {
	mini16_panel_xpm,
	mask16_bits,
	mask16_width,
	mask16_height,
}};

void
panel_init_m()
{
        int i;
	int event, error;
	static Pixmap mask = 0;

        if (app_data.shape 
	    && XShapeQueryExtension(XtDisplay(top), &event, &error)) {
                mask = XCreateBitmapFromData(XtDisplay(top),
			RootWindowOfScreen(XtScreen(top)),
			pixdata[app_data.cmode].mask, 
			pixdata[app_data.cmode].height,
			pixdata[app_data.cmode].width);
	}
        base = XtVaCreateManagedWidget("base", panelWidgetClass,
			top, 
			XtNpanelPixmapData,  pixdata[app_data.cmode].panel,
			XtNmask, mask,
                        NULL);
        qstat = XtVaCreateManagedWidget("qstat", qstatWidgetClass,
			base,
			XtNstate,       0,
			XtNauto,        0,
			XtNbackground, "black",
			XtNx, 0,
			XtNy, 0,
			XtNborderWidth, 0,
			NULL);
        sindc = XtVaCreateManagedWidget("sindicator", sindicatorWidgetClass,
			base, 
			XtNinRate,    0,
			XtNoutRate,   0,
			XtNbackground, "black",
			XtNx, 2,
			XtNy, 17,
			XtNborderWidth, 0,
			NULL);
        tdisp = XtVaCreateManagedWidget("time", timeWidgetClass,
			base,
			XtNtime,    -1,
			XtNbackground, "black",
			XtNx, 1,
			XtNy, 33,
			XtNborderWidth, 0,
			NULL);
}
