#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/xpm.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef	linux
#include <malloc.h>
#endif
#include <limits.h>
#include "xppxp.h"
#include "Panel.h"
#include "pixmap/icon.xpm"
#include "pixmap/ppxp.xpm"

Window icon;
Pixmap icon_pixmap;
Pixmap label_pixmap;
Pixmap mask;
XpmAttributes icon_attr;
XpmAttributes label_attr;

void
icon_init()
{
        int rst;

        icon_attr.valuemask = XpmReturnInfos 
                       | XpmReturnAllocPixels
                       | XpmReturnExtensions;
        rst = XpmCreatePixmapFromData(XtDisplay(top),
                                XRootWindowOfScreen(XtScreen(top)),
                                icon_xpm, &(icon_pixmap), &mask, &icon_attr);
        if (rst != 0) XpmError(rst);
        if (mask) XFreePixmap(XtDisplay(top), mask);

        load_label();
        if (label_pixmap) {
                XCopyArea(XtDisplay(top), label_pixmap, icon_pixmap,
                          DefaultGCOfScreen(XtScreen(top)),
                          0, 0, 64, 24, 3, 3);
        }

        icon = XCreateSimpleWindow(XtDisplay(top),
                                   XRootWindowOfScreen(XtScreen(top)),
                                   0, 0, icon_attr.width, icon_attr.height,
                                   0, 0, 0);
        XSetWindowBackgroundPixmap(XtDisplay(top), icon, icon_pixmap);
        XtVaSetValues(top, XtNiconWindow, icon, NULL);
}

void
icon_finish()
{
        Colormap cmap;

        cmap=DefaultColormapOfScreen(XtScreen(top));

        if (icon_pixmap) {
                XFreePixmap(XtDisplay(top), icon_pixmap);
                XFreeColors(XtDisplay(top), cmap,
                            icon_attr.alloc_pixels,
                            icon_attr.nalloc_pixels, 0);
                XpmFreeAttributes(&icon_attr);
        }

        if (label_pixmap) {
                XFreePixmap(XtDisplay(top), label_pixmap);
                cmap=DefaultColormapOfScreen(XtScreen(top));
                XFreeColors(XtDisplay(top), cmap,
                            label_attr.alloc_pixels,
                            label_attr.nalloc_pixels, 0);
                XpmFreeAttributes(&label_attr);
        }
}

void load_label()
{
        int rst;

        char fname[PATH_MAX];
        char *path;
        char *label;

        if (app_data.directory && app_data.directory[0]) {
                path = app_data.directory;
        } else {
                path = XPPXPDIR;
        }
        if (app_data.label && app_data.label[0]) {
                label = app_data.label;
        } else if (sc_name[0]) {
                label = sc_name;
        } else {
                label = "ppxp";
        }

        if (label && strlen(path)+strlen(label)+6 < PATH_MAX) {
                sprintf(fname, "%s/%s.xpm", path, label);
                if (access(fname, R_OK)) {
                        sprintf(fname, "%s/%s.xpm", path, "ppxp");
                }
        } else {
                fname[0]=0;
        }
        if (fname[0]) {
                label_attr.valuemask = XpmReturnInfos 
                                     | XpmReturnAllocPixels
                                     | XpmReturnExtensions;
                rst = XpmReadFileToPixmap(XtDisplay(top),
                                XRootWindowOfScreen(XtScreen(top)),
                                fname, &(label_pixmap), &mask, &label_attr);
                if (rst == 0) {
                        if (mask) XFreePixmap(XtDisplay(top), mask);
                } else {
                        label_pixmap = 0;
                }
        }
}

void
reload_label()
{
        int rst;
        Colormap cmap;
        cmap=DefaultColormapOfScreen(XtScreen(top));

        if (label_pixmap) {
                XFreePixmap(XtDisplay(top), label_pixmap);
                cmap=DefaultColormapOfScreen(XtScreen(top));
                XFreeColors(XtDisplay(top), cmap,
                            label_attr.alloc_pixels,
                            label_attr.nalloc_pixels, 0);
                XpmFreeAttributes(&label_attr);
        }
        load_label();
        if (label_pixmap) {
                XCopyArea(XtDisplay(top), label_pixmap, icon_pixmap,
                          DefaultGCOfScreen(XtScreen(top)),
                          0, 0, 64, 24, 3, 3);
                XSetWindowBackgroundPixmap(XtDisplay(top), icon, icon_pixmap);
                XtVaSetValues(top, XtNiconWindow, icon, NULL);
                XtVaSetValues(base, XtNlabelPixmap, label_pixmap, NULL);
        }
}
