#
#
#
#

proc log:find_syslog {fac} {
    return {}
}

proc log:insert_log_text {fid widget} {
    set text ""

    if {![winfo exists $widget] || [catch {set text [read $fid]}]} {
	return
    }
    if {$text != ""} {
	$widget configure -state normal
	$widget insert end $text

	while {1} {
	    set text [read $fid]
	    if {$text == ""} {
		break
	    }
	    $widget insert end $text
	}
	$widget configure -state disabled
	$widget see end
    }
    after 1000 [list log:insert_log_text $fid $widget]
}

proc log:find_file {} {
    global PPxPVar PPxP_UsrPath PPXPLOG

    if {![info exists PPxPVar(LOG.FILE)] || $PPxPVar(LOG.FILE) == ""} {
	set filename LOCAL0
    } else {
	set filename $PPxPVar(LOG.FILE)
    }
    if {
	$filename == "AUTH" || $filename == "AUTHPRIV" ||
	$filename == "DAEMON" || [regexp {LOCAL[0-7]} $filename]
    } {
	set full_path [log:find_syslog $filename]
    } elseif ![info exists PPxP_UsrPath] {
	set full_path [file join $PPXPLOG $filename]
	if ![file exists $full_path] {
	    set full_path ""
	}
    } else {
	set full_path [file join $PPxP_UsrPath log $filename]
	if ![file exists $full_path] {
	    set full_path [file join $PPXPLOG $filename]
	    If ![file exists $full_path] {
		set full_path ""
	    }
	}
    }
    return $full_path
}

proc log:start_showing {widget} {
    global log_file_name log_file_id

    catch {
	if {$log_file_id != ""} {
	    close $log_file_id
	    set log_file_id ""
	}
    }
    set log_file_id ""
    set log_file_name [log:find_file]

    if {$log_file_name == ""} {
	tk_messageBox -type ok -message "Can't find log file."
    } elseif ![file readable $log_file_name] {
	tk_messageBox -type ok -message "Can't read $log_file_name"
    } else {
	set log_file_id [open $log_file_name]
	log:insert_log_text $log_file_id $widget.text
	bind $widget <Destroy> [list catch "close $log_file_id"]
    }
}

proc log:start_window {w args} {
    global log_file_name

    frame $w.f1

    label $w.logFileLabel
    label $w.filenameLabel -textvariable log_file_name
    button $w.closeButton -command [list wm withdraw [winfo toplevel $w]]
    text $w.text -state disabled \
	-xscrollcommand "$w.xscroll set" \
	-yscrollcommand "$w.yscroll set"
    scrollbar $w.xscroll -orient horizontal -command "$w.text xview"
    scrollbar $w.yscroll -orient vertical   -command "$w.text yview"

    pack $w.logFileLabel $w.filenameLabel -side left -in $w.f1
    pack $w.closeButton -side right -in $w.f1

    grid $w.text    -column 0 -row 0 -sticky ewns
    grid $w.xscroll -column 0 -row 1 -sticky ew
    grid $w.yscroll -column 1 -row 0 -sticky ns
    grid $w.f1      -column 0 -row 2 -sticky ew -columnspan 2

    grid columnconfigure $w 0 -weight 1
    grid rowconfigure    $w 0 -weight 1

    log:start_showing $w
    PPxP:UpdateVarWidget $w LOG.FILE [list log:start_showing $w]
}

proc Log:Start {main_flag} {
    Toplevel:Start .tkppxpLog TkppxpLog "PPxP Log Window" $main_flag \
	log:start_window {}
}
