#include <stdio.h>
#include <stdarg.h>

#include "fppxp.h"

#include <support.h>
#include <xcio.h>
#include <ppxp.h>

int ppxpFd;

FL_FORM *mainForm;
static FL_OBJECT *msgObj[2];
static void (*outLineProc)();
char termCommand[256];
char startupPanel[20];

static struct {
    int width;
    int height;
} resRec;

FL_RESOURCE resDefs[]={
    {"width", "XForm.width", FL_INT, &resRec.width, "96"},
    {"height", "XForm.height", FL_INT, &resRec.height, "96"},
    {"terminal", "XForm.terminal", FL_STRING, termCommand,
	 "/usr/X11R6/bin/xterm", sizeof(termCommand)},
    {"panel", "XForm.panel", FL_STRING, startupPanel,
	 "Monitor", sizeof(startupPanel)},
};

#define	NUM_RESDEFS	(sizeof(resDefs)/sizeof(FL_RESOURCE))

FL_OBJECT **
CreateMessagePanel(int x, int y, int w, int h)
{
    int n;
    char *startup[]={
	" ",
	"@C8@c@l@b@ifPPxP",
	" ",
	0
    };

    msgObj[0] = fl_add_browser(FL_NORMAL_BROWSER,
			       x, y, w, h, "");
    fl_set_object_color(msgObj[0], FL_MCOL, FL_MCOL);
    fl_set_object_boxtype(msgObj[0], FL_DOWN_BOX);
    fl_set_object_bw(msgObj[0], 1);
    fl_set_browser_scrollbarsize(msgObj[0], FRAME_GAP, FRAME_GAP);
    for (n = 0; startup[n]; n ++)
	fl_add_browser_line(msgObj[0], startup[n]);
    return(msgObj);
}

void
XcUpdate(struct pppinfo_s *pppinfo)
{
/*    UpdatePixmapButton(&pppInfo, pppinfo);*/
    UpdateSysline(&pppInfo, pppinfo);
    UpdateButtons(&pppInfo, pppinfo);
    UpdatePanels(&pppInfo, pppinfo);
    memcpy(&pppInfo, pppinfo, sizeof(pppInfo));
}

static int
TtyOut(char *buf, int len)
{
    if (outLineProc) {
	outLineProc(buf, len);
    } else if (msgObj[0]) {
	fl_freeze_form(mainForm);
	fl_addto_browser_chars(msgObj[0], buf);
	fl_unfreeze_form(mainForm);
    } else write(0, buf, len);
    return(0);
}

void
XcCallBack(int fd, void *arg)
{
    int n;
    bool_t update=FALSE;
    struct xcio_s xc;

/*    while ((n = PPxPRead(fd, XID_UPDATE, &xc)) > 0) {*/
    if ((n = PPxPRead(fd, XID_UPDATE, &xc)) > 0) {
	switch (xc.type) {
	case XCIO_UP_ENVS:
	    break;
	case XCIO_UP_INFO:
	    XcUpdate((struct pppinfo_s *)&xc.buf);
	    break;
	}
    }
    if (n < 0) exit(1);
}

int
XcCommand(xcmd_t type, void (*cb)(), ...)
{
    va_list ap;
    int argc, n, ret=-1;
    char *com, *argv[32];
    struct xcio_s xc;
    u_int8_t xid;

    argc = 0;
    va_start(ap, cb);
    while (com = va_arg(ap, char *)) argv[argc ++] = strdup(com);
    va_end(ap);
    xid = PPxPCommand(ppxpFd, type, argc, argv);
    while ((n = PPxPRead(ppxpFd, xid, &xc)) >= 0) if (n > 0) {
	if (xc.type == XCIO_RETURN) {
	    ret = xc.buf[0];
	    break;
	}
	if (cb) cb(&xc);
    }
    return(ret);
}

static int
AtClose(FL_FORM *form, void *arg)
{
/*
    XcCommand(fl_show_question("Do you want to kill PPXP?", 0) ?
	      "quit": "bye", NULL);
*/
    return(1);
}

#define	MAIN_WIDTH	370
#define	MAIN_HEIGHT	200

#define	OUT_WIDTH	250
#define	OUT_HEIGHT	115

char *
XcGetEnv(char *name)
{
    struct xcio_s xc;
    u_int8_t xid;

    xid = PPxPEnvRequestv(ppxpFd, name, NULL);
    return(PPxPEnvGet(ppxpFd, xid));
}

static FL_FORM *
CreateMainForm(int x, int y)
{
    FL_FORM *form;
    FL_OBJECT *obj;

    form = fl_bgn_form(FL_FLAT_BOX, MAIN_WIDTH, MAIN_HEIGHT);
    fl_set_form_geometry(form, x, y, MAIN_WIDTH, MAIN_HEIGHT);

    /* sysline line */
    CreateSysline(form);
    CreateButtons(form);
    CreatePanels(form);

    fl_end_form();

    fl_show_form(form, FL_PLACE_SIZE, FL_FULLBORDER, "fPPxP");
    memset(&pppInfo, 0xff, sizeof(pppInfo));
    pppInfo.minfo = 0;
    return(form);
}

int
main(int argc, char *argv[])
{
    int i, fd=-1, x, y, w, h;
    FL_OBJECT *obj;
    struct envlink_s *elp;

    if ((ppxpFd = PPxPSetup(&argc, argv)) < 0) exit(-1);

    x = y = 0;

    fl_initialize(&argc, argv, "fPPxP", 0, 0);

    for (i = 1; i < argc; i ++) {
	if (*argv[i] == '-') {
	    if (!strncmp(argv[i], "-geom", 5)) {
		int d;
		i ++;
		if (strchr(argv[i], 'x'))
		    sscanf(argv[i], "%dx%d%d%d", &d, &d, &x, &y);
		else
		    sscanf(argv[i], "%d%d", &x, &y);
	    }
	}
    }

    fl_get_app_resources(resDefs, NUM_RESDEFS);

/*    miniForm = CreateMiniForm(x, y);*/
    mainForm = CreateMainForm(x, y);

    PPxPAutoUpdate(ppxpFd, TRUE);

    fl_add_io_callback(ppxpFd, FL_READ, XcCallBack, NULL);

/*    XcEnvCommand("version", NULL);*/
    printf("<%s>\n", XcGetEnv("version"));

    fl_set_atclose(AtClose, NULL);
#if 0
    if (msgObj[0]) {
	if ((elp = GetEnv("version")) != NULL) {
	    char buf[80];

	    sprintf(buf, "@cPPxP version %s", elp->data);
	    fl_add_browser_line(msgObj[0], buf);
	}
	fl_addto_browser_chars(msgObj[0], "\n");
    }
#endif
    while (1) {
	fl_check_forms();
    }
}
